/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class MergedSortedCacheWindowStoreKeyValueIterator
extends AbstractMergedSortedCacheStoreIterator<Windowed<Bytes>, Windowed<Bytes>, byte[], byte[]> {
    private final StateSerdes<Bytes, byte[]> serdes;
    private final long windowSize;
    private final SegmentedCacheFunction cacheFunction;

    MergedSortedCacheWindowStoreKeyValueIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> filteredCacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator, StateSerdes<Bytes, byte[]> serdes, long windowSize, SegmentedCacheFunction cacheFunction) {
        super(filteredCacheIterator, underlyingIterator);
        this.serdes = serdes;
        this.windowSize = windowSize;
        this.cacheFunction = cacheFunction;
    }

    @Override
    Windowed<Bytes> deserializeStoreKey(Windowed<Bytes> key) {
        return key;
    }

    @Override
    KeyValue<Windowed<Bytes>, byte[]> deserializeStorePair(KeyValue<Windowed<Bytes>, byte[]> pair) {
        return pair;
    }

    @Override
    Windowed<Bytes> deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = this.cacheFunction.key(cacheKey).get();
        long timestamp = WindowStoreUtils.timestampFromBinaryKey(binaryKey);
        Bytes key = WindowStoreUtils.keyFromBinaryKey(binaryKey, this.serdes);
        return new Windowed<Bytes>(key, WindowStoreUtils.timeWindowForSize(timestamp, this.windowSize));
    }

    @Override
    byte[] deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return cacheEntry.value;
    }

    @Override
    int compare(Bytes cacheKey, Windowed<Bytes> storeKey) {
        Bytes storeKeyBytes = WindowStoreUtils.toBinaryKey(storeKey.key().get(), storeKey.window().start(), 0);
        return this.cacheFunction.compareSegmentedKeys(cacheKey, storeKeyBytes);
    }
}

