/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionHelpers;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.FieldParsersKt;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0007\b\u0017\u0018\u0000 _2\u00020\u0001:\u0005_`abcB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0016\u0010N\u001a\u00020?2\u0006\u0010O\u001a\u00020\u00062\u0006\u0010P\u001a\u00020\u0006J\b\u0010Q\u001a\u00020\u0000H\u0016J\u001e\u0010R\u001a\u00020S2\u0014\u0010T\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u001b\u0018\u00010UH\u0002J\u0006\u0010V\u001a\u00020SJ\u0012\u0010W\u001a\u0004\u0018\u00010?2\u0006\u0010X\u001a\u00020\u0006H\u0002J\u0010\u0010Y\u001a\u0004\u0018\u00010?2\u0006\u0010X\u001a\u00020\u0006J\u000e\u0010Z\u001a\u00020S2\u0006\u0010O\u001a\u00020\u0006J\u0014\u0010[\u001a\u00020S2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00060]J\b\u0010^\u001a\u00020:H\u0016R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00060\nR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R$\u0010$\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R$\u0010(\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010+R$\u0010,\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u001e\"\u0004\b-\u0010 R$\u0010.\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u0012\"\u0004\b0\u0010+R\u0011\u00101\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0012R\u0011\u00103\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0012R$\u00106\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0012\"\u0004\b8\u0010+R\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0016\u0010=\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010@\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010\u0012\"\u0004\bB\u0010+R$\u0010C\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010H\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010E\"\u0004\bJ\u0010GR$\u0010K\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bL\u0010\u0012\"\u0004\bM\u0010+\u00a8\u0006d"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket;", "Lorg/jitsi/rtp/Packet;", "buffer", "", "([B)V", "offset", "", "length", "([BII)V", "_encodedHeaderExtensions", "Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "_payloadType", "_sequenceNumber", "_ssrc", "", "_timestamp", "csrcCount", "getCsrcCount", "()I", "csrcs", "", "getCsrcs", "()Ljava/util/List;", "encodedHeaderExtensions", "getEncodedHeaderExtensions", "()Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "value", "", "hasEncodedExtensions", "getHasEncodedExtensions", "()Z", "setHasEncodedExtensions", "(Z)V", "hasExtensions", "getHasExtensions", "setHasExtensions", "hasPadding", "getHasPadding", "setHasPadding", "<set-?>", "headerLength", "getHeaderLength", "setHeaderLength", "(I)V", "isMarked", "setMarked", "paddingSize", "getPaddingSize", "setPaddingSize", "payloadLength", "getPayloadLength", "payloadOffset", "getPayloadOffset", "newValue", "payloadType", "getPayloadType", "setPayloadType", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "pendingHeaderExtensions", "", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "sequenceNumber", "getSequenceNumber", "setSequenceNumber", "ssrc", "getSsrc", "()J", "setSsrc", "(J)V", "timestamp", "getTimestamp", "setTimestamp", "version", "getVersion", "setVersion", "addHeaderExtension", "id", "extDataLength", "clone", "createPendingHeaderExtensions", "", "removeIf", "Lkotlin/Function1;", "encodeHeaderExtensions", "getEncodedHeaderExtension", "extensionId", "getHeaderExtension", "removeHeaderExtension", "removeHeaderExtensionsExcept", "retain", "", "toString", "Companion", "EncodedHeaderExtension", "EncodedHeaderExtensions", "HeaderExtension", "PendingHeaderExtension", "rtp"})
@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="We intentionally pass a reference to our buffer when using observableWhenChanged.")
public class RtpPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int _payloadType;
    private int _sequenceNumber;
    private long _timestamp;
    private long _ssrc;
    private int headerLength;
    @NotNull
    private final EncodedHeaderExtensions _encodedHeaderExtensions;
    @Nullable
    private List<HeaderExtension> pendingHeaderExtensions;
    public static final int HEADER_EXT_HEADER_SIZE = 1;
    public static final int BYTES_TO_LEAVE_AT_START_OF_PACKET = 10;

    public RtpPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(buffer, offset, length);
        this._payloadType = RtpHeader.Companion.getPayloadType(buffer, offset);
        this._sequenceNumber = RtpHeader.Companion.getSequenceNumber(buffer, offset);
        this._timestamp = RtpHeader.Companion.getTimestamp(buffer, offset);
        this._ssrc = RtpHeader.Companion.getSsrc(buffer, offset);
        this.headerLength = RtpHeader.Companion.getTotalLength(buffer, offset);
        if (this.headerLength > length) {
            throw new IllegalArgumentException("RTP packet header length " + this.headerLength + " > length " + length);
        }
        this._encodedHeaderExtensions = new EncodedHeaderExtensions();
    }

    public RtpPacket(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this(buffer, 0, buffer.length);
    }

    public final int getVersion() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getVersion(this.buffer, this.offset);
    }

    public final void setVersion(int value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setVersion(this.buffer, this.offset, value2);
    }

    public final boolean getHasPadding() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.hasPadding(this.buffer, this.offset);
    }

    public final void setHasPadding(boolean value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setPadding(this.buffer, this.offset, value2);
    }

    private final boolean getHasEncodedExtensions() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.hasExtensions(this.buffer, this.offset);
    }

    private final void setHasEncodedExtensions(boolean value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setHasExtensions(this.buffer, this.offset, value2);
    }

    public final int getCsrcCount() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getCsrcCount(this.buffer, this.offset);
    }

    public final boolean isMarked() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getMarker(this.buffer, this.offset);
    }

    public final void setMarked(boolean value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setMarker(this.buffer, this.offset, value2);
    }

    public final int getPayloadType() {
        return this._payloadType;
    }

    public final void setPayloadType(int newValue) {
        if (newValue != this._payloadType) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setPayloadType(this.buffer, this.offset, newValue);
            this._payloadType = newValue;
        }
    }

    public final int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public final void setSequenceNumber(int newValue) {
        if (newValue != this._sequenceNumber) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setSequenceNumber(this.buffer, this.offset, newValue);
            this._sequenceNumber = newValue;
        }
    }

    public final long getTimestamp() {
        return this._timestamp;
    }

    public final void setTimestamp(long newValue) {
        if (newValue != this._timestamp) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setTimestamp(this.buffer, this.offset, newValue);
            this._timestamp = newValue;
        }
    }

    public final long getSsrc() {
        return this._ssrc;
    }

    public final void setSsrc(long newValue) {
        if (newValue != this._ssrc) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setSsrc(this.buffer, this.offset, newValue);
            this._ssrc = newValue;
        }
    }

    @NotNull
    public final List<Long> getCsrcs() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getCsrcs(this.buffer, this.offset);
    }

    public final int getHeaderLength() {
        return this.headerLength;
    }

    protected final void setHeaderLength(int n) {
        this.headerLength = n;
    }

    public final int getPayloadLength() {
        return this.length - this.headerLength;
    }

    public final int getPayloadOffset() {
        return this.offset + this.headerLength;
    }

    public final int getPaddingSize() {
        if (!this.getHasPadding()) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return FieldParsersKt.getByteAsInt(this.buffer, this.offset + this.length - 1);
    }

    public final void setPaddingSize(int value2) {
        if (value2 > 0) {
            this.setHasPadding(true);
            this.buffer[this.offset + this.length - 1] = (byte)value2;
        } else {
            this.setHasPadding(false);
        }
    }

    private final EncodedHeaderExtensions getEncodedHeaderExtensions() {
        this._encodedHeaderExtensions.reset$rtp();
        return this._encodedHeaderExtensions;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        int n = this.getPayloadLength();
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return "type=RtpPacket len=" + n + " hashCode=" + ByteArrayExtensionsKt.hashCodeOfSegment(this.buffer, this.getPayloadOffset(), this.getPayloadOffset() + this.getPayloadLength());
    }

    private final HeaderExtension getEncodedHeaderExtension(int extensionId) {
        if (!this.getHasEncodedExtensions()) {
            return null;
        }
        Iterator $this$forEach$iv = this.getEncodedHeaderExtensions();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            HeaderExtension ext = (HeaderExtension)element$iv;
            boolean bl = false;
            if (ext.getId() != extensionId) continue;
            return ext;
        }
        return null;
    }

    public final boolean getHasExtensions() {
        List<HeaderExtension> list = this.pendingHeaderExtensions;
        return list != null ? !((Collection)list).isEmpty() : this.getHasEncodedExtensions();
    }

    public final void setHasExtensions(boolean value2) {
        List<HeaderExtension> p = this.pendingHeaderExtensions;
        if (p != null) {
            if (value2 && p.isEmpty()) {
                throw new IllegalStateException("Cannot set hasExtensions to true with empty pending extensions");
            }
            if (!value2) {
                p.clear();
            }
        } else {
            this.setHasEncodedExtensions(value2);
        }
    }

    @Nullable
    public final HeaderExtension getHeaderExtension(int extensionId) {
        List<HeaderExtension> activeHeaderExtensions;
        List<HeaderExtension> list = this.pendingHeaderExtensions;
        if (list == null || (list = list.iterator()) == null) {
            list = this.getEncodedHeaderExtensions();
        }
        List<HeaderExtension> $this$forEach$iv = activeHeaderExtensions = list;
        boolean $i$f$forEach = false;
        List<HeaderExtension> list2 = $this$forEach$iv;
        while (list2.hasNext()) {
            Object element$iv = list2.next();
            HeaderExtension ext = (HeaderExtension)element$iv;
            boolean bl = false;
            if (ext.getId() != extensionId) continue;
            return ext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void createPendingHeaderExtensions(Function1<? super HeaderExtension, Boolean> removeIf) {
        ArrayList arrayList;
        if (this.pendingHeaderExtensions != null) {
            return;
        }
        ArrayList arrayList2 = arrayList = new ArrayList();
        RtpPacket rtpPacket = this;
        boolean bl = false;
        Iterator $this$forEach$iv = this.getEncodedHeaderExtensions();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            void l;
            Object element$iv = iterator2.next();
            HeaderExtension it = (HeaderExtension)element$iv;
            boolean bl2 = false;
            if (removeIf != null && removeIf.invoke(it).booleanValue()) continue;
            l.add(new PendingHeaderExtension(it));
        }
        rtpPacket.pendingHeaderExtensions = arrayList;
    }

    public final void removeHeaderExtension(int id) {
        List<HeaderExtension> list = this.pendingHeaderExtensions;
        if (list != null) {
            list.removeIf(arg_0 -> RtpPacket.removeHeaderExtension$lambda-4(id, arg_0));
        } else {
            this.createPendingHeaderExtensions((Function1<? super HeaderExtension, Boolean>)new Function1<HeaderExtension, Boolean>(id){
                final /* synthetic */ int $id;
                {
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull HeaderExtension h2) {
                    Intrinsics.checkNotNullParameter(h2, "h");
                    return h2.getId() == this.$id;
                }
            });
        }
    }

    public final void removeHeaderExtensionsExcept(@NotNull Set<Integer> retain) {
        Intrinsics.checkNotNullParameter(retain, "retain");
        List<HeaderExtension> list = this.pendingHeaderExtensions;
        if (list != null) {
            list.removeIf(arg_0 -> RtpPacket.removeHeaderExtensionsExcept$lambda-5(retain, arg_0));
        } else {
            this.createPendingHeaderExtensions((Function1<? super HeaderExtension, Boolean>)new Function1<HeaderExtension, Boolean>(retain){
                final /* synthetic */ Set<Integer> $retain;
                {
                    this.$retain = $retain;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull HeaderExtension h2) {
                    Intrinsics.checkNotNullParameter(h2, "h");
                    return !this.$retain.contains(h2.getId());
                }
            });
        }
    }

    @NotNull
    public final HeaderExtension addHeaderExtension(int id, int extDataLength) {
        block5: {
            block4: {
                boolean bl = 1 <= id ? id < 16 : false;
                if (!bl) break block4;
                if (1 <= extDataLength ? extDataLength < 17 : false) break block5;
            }
            throw new IllegalArgumentException("id=" + id + " len=" + extDataLength + ")");
        }
        PendingHeaderExtension newHeader = new PendingHeaderExtension(id, extDataLength);
        if (this.pendingHeaderExtensions == null) {
            this.createPendingHeaderExtensions(null);
        }
        List<HeaderExtension> list = this.pendingHeaderExtensions;
        Intrinsics.checkNotNull(list);
        list.add(newHeader);
        return newHeader;
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeHeaderExtensions() {
        byte[] byArray;
        int n;
        List<HeaderExtension> list = this.pendingHeaderExtensions;
        if (list == null) {
            return;
        }
        List<HeaderExtension> pendingHeaderExtensions = list;
        int currHeaderLength = this.headerLength;
        int currPayloadLength = this.getPayloadLength();
        int baseHeaderLength = 12 + this.getCsrcCount() * 4;
        if (pendingHeaderExtensions.isEmpty()) {
            n = 0;
        } else {
            int n2;
            Iterable iterable = pendingHeaderExtensions;
            int n3 = 4;
            int n4 = 0;
            for (Object object : iterable) {
                void h2;
                HeaderExtension headerExtension = (HeaderExtension)object;
                n2 = n4;
                boolean bl = false;
                int n5 = h2.getTotalLengthBytes();
                n4 = n2 + n5;
            }
            n2 = n4;
            int rawHeaderLength = n3 + n2;
            n = rawHeaderLength + RtpUtils.Companion.getNumPaddingBytes(rawHeaderLength);
        }
        int newExtHeaderLength = n;
        int newHeaderLength = baseHeaderLength + newExtHeaderLength;
        int newPacketLength = newHeaderLength + currPayloadLength;
        int newPayloadOffset = 0;
        if (this.buffer.length >= newPacketLength + 20) {
            if (this.offset + currHeaderLength >= newPacketLength - currPayloadLength) {
                newPayloadOffset = this.getPayloadOffset();
            } else {
                newPayloadOffset = this.buffer.length - currPayloadLength - 20;
                System.arraycopy(this.buffer, this.getPayloadOffset(), this.buffer, newPayloadOffset, currPayloadLength);
            }
            byArray = this.buffer;
        } else {
            Object object;
            object = BufferPool.Companion.getGetArray().invoke(newPacketLength + 20);
            byte[] $this$encodeHeaderExtensions_u24lambda_u2d7 = (byte[])object;
            boolean bl = false;
            newPayloadOffset = $this$encodeHeaderExtensions_u24lambda_u2d7.length - currPayloadLength - 20;
            System.arraycopy(this.buffer, this.getPayloadOffset(), $this$encodeHeaderExtensions_u24lambda_u2d7, newPayloadOffset, currPayloadLength);
            byArray = (byte[])object;
        }
        byte[] newBuffer = byArray;
        int newOffset = newPayloadOffset - newHeaderLength;
        if (this.buffer != newBuffer || this.offset != newOffset) {
            System.arraycopy(this.buffer, this.offset, newBuffer, newOffset, baseHeaderLength);
        }
        if (!((Collection)pendingHeaderExtensions).isEmpty()) {
            int off = 0;
            off = newOffset + baseHeaderLength;
            Intrinsics.checkNotNullExpressionValue(newBuffer, "newBuffer");
            ByteArrayExtensionsKt.putShort(newBuffer, off, (short)-16674);
            ByteArrayExtensionsKt.putShort(newBuffer, off + 2, (short)((newExtHeaderLength - 4) / 4));
            off += 4;
            Iterable $this$forEach$iv = pendingHeaderExtensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeaderExtension h3 = (HeaderExtension)element$iv;
                boolean bl = false;
                System.arraycopy(h3.getCurrExtBuffer(), h3.getCurrExtOffset(), newBuffer, off, h3.getCurrExtLength());
                off += h3.getCurrExtLength();
            }
            while (off < newOffset + newHeaderLength) {
                newBuffer[off] = 0;
                int n6 = off;
                off = n6 + 1;
            }
        }
        byte[] oldBuffer = this.buffer;
        this.buffer = newBuffer;
        if (oldBuffer != newBuffer) {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnArray();
            Intrinsics.checkNotNullExpressionValue(oldBuffer, "oldBuffer");
            function1.invoke(oldBuffer);
        }
        this.offset = newOffset;
        this.length = newPacketLength;
        this.headerLength = newHeaderLength;
        this.setHasEncodedExtensions(!((Collection)pendingHeaderExtensions).isEmpty());
        this.pendingHeaderExtensions = null;
    }

    @Override
    @NotNull
    public RtpPacket clone() {
        RtpPacket rtpPacket;
        RtpPacket it = rtpPacket = new RtpPacket(this.cloneBuffer(10), 10, this.length);
        boolean bl = false;
        if (this.pendingHeaderExtensions != null) {
            it.pendingHeaderExtensions = new ArrayList(this.pendingHeaderExtensions);
        }
        return rtpPacket;
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u2d10 = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d10.append("RtpPacket: ");
        $this$toString_u24lambda_u2d10.append("PT=" + this.getPayloadType());
        $this$toString_u24lambda_u2d10.append(", Ssrc=" + this.getSsrc());
        $this$toString_u24lambda_u2d10.append(", SeqNum=" + this.getSequenceNumber());
        $this$toString_u24lambda_u2d10.append(", M=" + this.isMarked());
        $this$toString_u24lambda_u2d10.append(", X=" + this.getHasEncodedExtensions());
        $this$toString_u24lambda_u2d10.append(", Ts=" + this.getTimestamp());
        String string = $this$toString_u24lambda_u2d10.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(StringBuilder()) {\n\u2026\n        toString()\n    }");
        return string;
    }

    private static final boolean removeHeaderExtension$lambda-4(int $id, HeaderExtension h2) {
        Intrinsics.checkNotNullParameter(h2, "h");
        return h2.getId() == $id;
    }

    private static final boolean removeHeaderExtensionsExcept$lambda-5(Set $retain, HeaderExtension h2) {
        Intrinsics.checkNotNullParameter($retain, "$retain");
        Intrinsics.checkNotNullParameter(h2, "h");
        return !$retain.contains(h2.getId());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "", "()V", "currExtBuffer", "", "getCurrExtBuffer", "()[B", "<set-?>", "", "currExtLength", "getCurrExtLength", "()I", "setCurrExtLength", "(I)V", "currExtOffset", "getCurrExtOffset", "setCurrExtOffset", "dataLengthBytes", "getDataLengthBytes", "newId", "id", "getId", "setId", "totalLengthBytes", "getTotalLengthBytes", "setOffsetLength", "", "nextHeaderExtOffset", "nextHeaderExtLength", "rtp"})
    public static abstract class HeaderExtension {
        private int currExtOffset;
        private int currExtLength;

        public final int getCurrExtOffset() {
            return this.currExtOffset;
        }

        protected final void setCurrExtOffset(int n) {
            this.currExtOffset = n;
        }

        public final int getCurrExtLength() {
            return this.currExtLength;
        }

        protected final void setCurrExtLength(int n) {
            this.currExtLength = n;
        }

        @NotNull
        public abstract byte[] getCurrExtBuffer();

        public final void setOffsetLength(int nextHeaderExtOffset, int nextHeaderExtLength) {
            this.currExtOffset = nextHeaderExtOffset;
            this.currExtLength = nextHeaderExtLength;
        }

        public final int getId() {
            if (this.currExtLength <= 0) {
                return -1;
            }
            return HeaderExtensionHelpers.Companion.getId(this.getCurrExtBuffer(), this.currExtOffset);
        }

        public final void setId(int newId) {
            if (this.currExtLength <= 0) {
                throw new IllegalStateException("Can't set ID on header extension with no length");
            }
            HeaderExtensionHelpers.Companion.setId(newId, this.getCurrExtBuffer(), this.currExtOffset);
        }

        public final int getDataLengthBytes() {
            return HeaderExtensionHelpers.Companion.getDataLengthBytes(this.getCurrExtBuffer(), this.currExtOffset);
        }

        public final int getTotalLengthBytes() {
            return 1 + this.getDataLengthBytes();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "(Lorg/jitsi/rtp/rtp/RtpPacket;)V", "currExtBuffer", "", "getCurrExtBuffer", "()[B", "rtp"})
    public final class EncodedHeaderExtension
    extends HeaderExtension {
        @Override
        @NotNull
        public byte[] getCurrExtBuffer() {
            Intrinsics.checkNotNullExpressionValue(RtpPacket.this.buffer, "this@RtpPacket.buffer");
            return RtpPacket.this.buffer;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$PendingHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "other", "(Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;)V", "id", "", "extDataLength", "(II)V", "currExtBuffer", "", "getCurrExtBuffer", "()[B", "rtp"})
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="We intentionally expose the internal buffer.")
    public static final class PendingHeaderExtension
    extends HeaderExtension {
        @NotNull
        private final byte[] currExtBuffer;

        public PendingHeaderExtension(int id, int extDataLength) {
            this.currExtBuffer = new byte[extDataLength + 1];
            this.setCurrExtLength(extDataLength + 1);
            this.getCurrExtBuffer()[0] = (byte)((byte)((id & 0xF) << 4) | (byte)(extDataLength - 1 & 0xF));
        }

        @Override
        @NotNull
        public byte[] getCurrExtBuffer() {
            return this.currExtBuffer;
        }

        public PendingHeaderExtension(@NotNull HeaderExtension other) {
            Intrinsics.checkNotNullParameter(other, "other");
            this(other.getId(), other.getDataLengthBytes());
            System.arraycopy(other.getCurrExtBuffer(), other.getCurrExtOffset() + 1, this.getCurrExtBuffer(), 1, this.getDataLengthBytes());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\bH\u0002J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0002H\u0096\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "(Lorg/jitsi/rtp/rtp/RtpPacket;)V", "currHeaderExtension", "getCurrHeaderExtension", "()Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "nextOffset", "", "remainingLength", "getNextExtLength", "hasNext", "", "next", "reset", "", "reset$rtp", "rtp"})
    public final class EncodedHeaderExtensions
    implements Iterator<HeaderExtension>,
    KMappedMarker {
        private int nextOffset;
        private int remainingLength;
        @NotNull
        private final HeaderExtension currHeaderExtension;

        public EncodedHeaderExtensions() {
            this.currHeaderExtension = new EncodedHeaderExtension();
        }

        @NotNull
        public final HeaderExtension getCurrHeaderExtension() {
            return this.currHeaderExtension;
        }

        @Override
        public boolean hasNext() {
            while (this.remainingLength > 0 && RtpUtilsKt.isPadding(RtpPacket.this.buffer[this.nextOffset])) {
                int n = this.nextOffset;
                this.nextOffset = n + 1;
                n = this.remainingLength;
                this.remainingLength = n + -1;
            }
            if (this.remainingLength <= 0 || this.nextOffset < 0) {
                return false;
            }
            return this.getNextExtLength() > 0;
        }

        @Override
        @NotNull
        public HeaderExtension next() {
            int nextExtLen = this.getNextExtLength();
            if (nextExtLen <= 0) {
                throw new Exception("Invalid extension length.  Did hasNext() return true?");
            }
            this.currHeaderExtension.setOffsetLength(this.nextOffset, nextExtLen);
            this.nextOffset += nextExtLen;
            this.remainingLength -= nextExtLen;
            return this.currHeaderExtension;
        }

        private final int getNextExtLength() {
            if (this.remainingLength < 2) {
                return -1;
            }
            Intrinsics.checkNotNullExpressionValue(RtpPacket.this.buffer, "buffer");
            int extLen = HeaderExtensionHelpers.Companion.getEntireLengthBytes(RtpPacket.this.buffer, this.nextOffset);
            return extLen > this.remainingLength ? -1 : extLen;
        }

        public final void reset$rtp() {
            int extLength;
            int n;
            if (RtpPacket.this.getHasEncodedExtensions()) {
                Intrinsics.checkNotNullExpressionValue(RtpPacket.this.buffer, "buffer");
                int extensionBlockLength = HeaderExtensionHelpers.Companion.getExtensionsTotalLength(RtpPacket.this.buffer, RtpPacket.this.offset + 12 + RtpPacket.this.getCsrcCount() * 4);
                n = extensionBlockLength - 4;
            } else {
                n = extLength = 0;
            }
            if (extLength <= 0) {
                this.nextOffset = -1;
                this.remainingLength = -1;
            } else {
                this.nextOffset = RtpPacket.this.offset + 12 + RtpPacket.this.getCsrcCount() * 4 + 4;
                this.remainingLength = extLength;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$Companion;", "", "()V", "BYTES_TO_LEAVE_AT_START_OF_PACKET", "", "HEADER_EXT_HEADER_SIZE", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

