/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;

public abstract class BaseInstructionSplitterVisitor {
    protected ClassFile classFile;
    protected ConstantPool constants;

    public void start(ClassFile classFile) {
        this.classFile = classFile;
        this.constants = classFile == null ? null : classFile.getConstantPool();
    }

    public void visit(Instruction instruction) {
        this.visit(null, instruction);
    }

    protected void visit(Instruction parent, Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                this.visit(instruction, ((ArrayLength)instruction).arrayref);
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                this.visit(instruction, ali.arrayref);
                this.visit(instruction, ali.indexref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(instruction, asi.arrayref);
                this.visit(instruction, asi.indexref);
                this.visit(instruction, asi.valueref);
                break;
            }
            case 189: {
                this.visit(instruction, ((ANewArray)instruction).dimension);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(instruction, ai.test);
                if (ai.msg == null) break;
                this.visit(instruction, ai.msg);
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(instruction, boi.value1);
                this.visit(instruction, boi.value2);
                break;
            }
            case 191: {
                this.visit(instruction, ((AThrow)instruction).value);
                break;
            }
            case 266: {
                this.visit(instruction, ((UnaryOperatorInstruction)instruction).value);
                break;
            }
            case 275: 
            case 276: {
                this.visit(instruction, ((ConvertInstruction)instruction).value);
                break;
            }
            case 192: {
                this.visit(instruction, ((CheckCast)instruction).objectref);
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.instruction == null) break;
                this.visit(instruction, fd.instruction);
                break;
            }
            case 180: {
                this.visit(instruction, ((GetField)instruction).objectref);
                break;
            }
            case 260: 
            case 262: {
                this.visit(instruction, ((IfInstruction)instruction).value);
                break;
            }
            case 261: {
                IfCmp ic = (IfCmp)instruction;
                this.visit(instruction, ic.value1);
                this.visit(instruction, ic.value2);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int lenght = branchList.size();
                int i = 0;
                while (i < lenght) {
                    this.visit(instruction, branchList.get(i));
                    ++i;
                }
                break;
            }
            case 277: 
            case 278: {
                this.visit(instruction, ((IncInstruction)instruction).value);
                break;
            }
            case 274: {
                ClassFile innerClassFile;
                String prefix;
                InvokeNew in = (InvokeNew)instruction;
                List args = in.args;
                int lenght = args.size();
                int i = 0;
                while (i < lenght) {
                    this.visit(instruction, (Instruction)args.get(i));
                    ++i;
                }
                ConstantMethodref cmr = this.constants.getConstantMethodref(in.index);
                String internalClassName = this.constants.getConstantClassName(cmr.class_index);
                if (!internalClassName.startsWith(prefix = String.valueOf(this.classFile.getThisClassName()) + '$') || (innerClassFile = this.classFile.getInnerClassFile(internalClassName)) == null || innerClassFile.getInternalAnonymousClassName() == null) break;
                this.visitAnonymousNewInvoke(parent == null ? in : parent, in, innerClassFile);
                break;
            }
            case 193: {
                this.visit(instruction, ((InstanceOf)instruction).objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                this.visit(instruction, ((InvokeNoStaticInstruction)instruction).objectref);
            }
            case 184: {
                List<Instruction> args = ((InvokeInstruction)instruction).args;
                int lenght = args.size();
                int i = 0;
                while (i < lenght) {
                    this.visit(instruction, args.get(i));
                    ++i;
                }
                break;
            }
            case 170: 
            case 171: {
                this.visit(instruction, ((Switch)instruction).key);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int lenght = dimensions.length;
                int i = 0;
                while (i < lenght) {
                    this.visit(instruction, dimensions[i]);
                    ++i;
                }
                break;
            }
            case 188: {
                this.visit(instruction, ((NewArray)instruction).dimension);
                break;
            }
            case 87: {
                this.visit(instruction, ((Pop)instruction).objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(instruction, putField.objectref);
                this.visit(instruction, putField.valueref);
                break;
            }
            case 179: {
                this.visit(instruction, ((PutStatic)instruction).valueref);
                break;
            }
            case 273: {
                this.visit(instruction, ((ReturnInstruction)instruction).valueref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                this.visit(instruction, ((StoreInstruction)instruction).valueref);
                break;
            }
            case 280: {
                this.visit(instruction, ((TernaryOpStore)instruction).objectref);
                break;
            }
            case 281: {
                TernaryOperator tp = (TernaryOperator)instruction;
                this.visit(instruction, tp.test);
                this.visit(instruction, tp.value1);
                this.visit(instruction, tp.value2);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(instruction, iai.newArray);
                List<Instruction> values = iai.values;
                int lenght = values.size();
                int i = 0;
                while (i < lenght) {
                    this.visit(instruction, values.get(i));
                    ++i;
                }
                break;
            }
        }
    }

    public abstract void visitAnonymousNewInvoke(Instruction var1, InvokeNew var2, ClassFile var3);
}

