/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestTimeoutException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.ResponseImpl;
import com.google.gwt.user.client.Timer;
import com.google.gwt.xhr.client.XMLHttpRequest;

public class Request {
    private final RequestCallback callback;
    private final int timeoutMillis;
    private final Timer timer = new Timer(){

        @Override
        public void run() {
            Request.this.fireOnTimeout();
        }
    };
    private XMLHttpRequest xmlHttpRequest;

    private static Response createResponse(XMLHttpRequest xmlHttpRequest) {
        return ImplHolder.get().createResponse(xmlHttpRequest);
    }

    protected Request() {
        this.callback = null;
        this.timeoutMillis = 0;
        this.xmlHttpRequest = null;
    }

    Request(XMLHttpRequest xmlHttpRequest, int timeoutMillis, RequestCallback callback) {
        if (xmlHttpRequest == null) {
            throw new NullPointerException();
        }
        if (callback == null) {
            throw new NullPointerException();
        }
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException();
        }
        this.callback = callback;
        this.timeoutMillis = timeoutMillis;
        this.xmlHttpRequest = xmlHttpRequest;
        if (timeoutMillis > 0) {
            this.timer.schedule(timeoutMillis);
        }
    }

    public void cancel() {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.timer.cancel();
        XMLHttpRequest xhr = this.xmlHttpRequest;
        this.xmlHttpRequest = null;
        xhr.clearOnReadyStateChange();
        xhr.abort();
    }

    public boolean isPending() {
        if (this.xmlHttpRequest == null) {
            return false;
        }
        int readyState = this.xmlHttpRequest.getReadyState();
        switch (readyState) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    void fireOnResponseReceived(RequestCallback callback) {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.timer.cancel();
        XMLHttpRequest xhr = this.xmlHttpRequest;
        this.xmlHttpRequest = null;
        Response response = Request.createResponse(xhr);
        callback.onResponseReceived(this, response);
    }

    private void fireOnTimeout() {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.cancel();
        this.callback.onError(this, new RequestTimeoutException(this, this.timeoutMillis));
    }

    private static class ImplHolder {
        private static final RequestImpl impl = (RequestImpl)GWT.create(RequestImpl.class);

        private ImplHolder() {
        }

        public static RequestImpl get() {
            return impl;
        }
    }

    static class RequestImplIE8And9
    extends RequestImpl {
        RequestImplIE8And9() {
        }

        @Override
        Response createResponse(XMLHttpRequest xmlHttpRequest) {
            return new ResponseImpl(xmlHttpRequest){

                @Override
                public int getStatusCode() {
                    int statusCode = super.getStatusCode();
                    return statusCode == 1223 ? 204 : statusCode;
                }
            };
        }
    }

    static class RequestImpl {
        RequestImpl() {
        }

        Response createResponse(XMLHttpRequest xmlHttpRequest) {
            return new ResponseImpl(xmlHttpRequest);
        }
    }
}

