#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ñ᤿ե󤹤뤿Υ饹
#
package FreePWING::Sort;

require 5.005;
require Exporter;
use FileHandle;
use English;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $sort);

@ISA = qw(Exporter);

# sort ޥ
$sort = '/usr/bin/sort';

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ñեΥϥɥ
	'handle' => FileHandle->new(),

	# ñե̾
	'file_name' => '',

	# ޤǤ˽񤭹ȥ
	'entry_count' => 0,

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name)
#           file_name
#		ñե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽å
# :
# 	񤭹Ѥñե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name) = @ARG;
    my ($lc_all, $lc_ctype, $lc_collate, $lc_time, $lc_numeric, $lc_monetary,
	$lc_message);

    #
    # ߤΥĶѿ¸롣
    #
    $lc_all      = $ENV{'LC_ALL'};
    $lc_collate  = $ENV{'LC_COLLATE'};
    $lc_ctype    = $ENV{'LC_CTYPE'};
    $lc_time     = $ENV{'LC_TIME'};
    $lc_numeric  = $ENV{'LC_NUMERIC'};
    $lc_monetary = $ENV{'LC_MONETARY'};
    $lc_message  = $ENV{'LC_MESSAGE'};

    #
    # Ķѿ롣
    #
    if (defined($lc_all)) {
	$ENV{'LC_TIME'} = $lc_all;
	$ENV{'LC_NUMERIC'} = $lc_all;
	$ENV{'LC_MONETARY'} = $lc_all;
	$ENV{'LC_MESSAGE'} = $lc_all;
	delete($ENV{'LC_ALL'});
    }
    $ENV{'LC_CTYPE'} = 'C';
    $ENV{'LC_COLLATE'} = 'C';

    #
    # ñե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open("| $sort > $file_name")) {
	$self->{'error_message'} = 
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }

    #
    # Ķѿ򸵤᤹
    #
    defined($lc_all)
	? ($ENV{'LC_ALL'}      = $lc_all)      : delete($ENV{'LC_ALL'});
    defined($lc_collate)
	? ($ENV{'LC_COLLATE'}  = $lc_collate)  : delete($ENV{'LC_COLLATE'});
    defined($lc_ctype)
	? ($ENV{'LC_CTYPE'}    = $lc_ctype)    : delete($ENV{'LC_CTYPE'});
    defined($lc_time)
	? ($ENV{'LC_TIME'}     = $lc_time)     : delete($ENV{'LC_TIME'});
    defined($lc_numeric)
	? ($ENV{'LC_NUMERIC'}  = $lc_numeric)  : delete($ENV{'LC_NUMERIC'});
    defined($lc_monetary)
	? ($ENV{'LC_MONETARY'} = $lc_monetary) : delete($ENV{'LC_MONETARY'});
    defined($lc_message)
	? ($ENV{'LC_MESSAGE'}  = $lc_message)  : delete($ENV{'LC_MESSAGE'});

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;

    return $self->close_internal();
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#	close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
	if (($CHILD_ERROR & 255) != 0) {
	    if ($self->{'error_message'} eq '') {
		$self->{'error_message'} =
		    "failed to close the file: " . $self->{'file_name'};
	    }
	    return 0;
	}
    }

    return 1;
}

#
# :
#	add_entries_in_file(file_name)
#           file_name
#		ǥåΥȥ꤬줿ե롣
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	file_name ˵Ƥȥ򡢥ǥåե
#	Фɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entries_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # $file_name 򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: $file_name";
	$self->close_internal();
	return 0;
    }

    #
    # $file_name ɤߡƹԤ˵Ƥ륨ȥ $self ɲ
    # 롣
    #
    my $line;
    for (;;) {
	$line = $handle->getline();
	if (!defined($line)) {
	    last;
	}
	if (!$self->{'handle'}->print($line)) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $self->{'file_name'};
	    $self->close_internal();
	    return 0;
	}

	$self->{'entry_count'}++;
    }

    #
    # $file_name ΥϥɥĤ롣
    #
    $handle->close();

    return 1;
}

#
# :
#	add_entry(word, heading_position, heading_file_name,
#		  text_position, text_file_name)
#           word
#		ñ (줿)
#           heading_position
# 		Фΰ
#           heading_file_name
# 		ФΥե̾
#           text_position
# 		ʸΰ
#           text_file_name
# 		ʸΥե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեñɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;
    my ($word, $heading_position, $heading_file_name, $text_position,
	$text_file_name) = @ARG;

    if (!$self->{'handle'}
	->printf("%s\t%08x\t%s\t%08x\t%s\n", $word, $heading_position,
		 $heading_file_name, $text_position, $text_file_name)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }

    $self->{'entry_count'}++;
    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
