/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.Objects;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class JavaDependencyContextRefiner
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node2, DependencyGraphTransformationContext context) throws RepositoryException {
        String scope;
        Objects.requireNonNull(node2, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        String ctx2 = node2.getRequestContext();
        if ("project".equals(ctx2) && (scope = this.getClasspathScope(node2)) != null) {
            ctx2 = ctx2 + '/' + scope;
            node2.setRequestContext(ctx2);
        }
        for (DependencyNode child : node2.getChildren()) {
            this.transformGraph(child, context);
        }
        return node2;
    }

    private String getClasspathScope(DependencyNode node2) {
        Dependency dependency = node2.getDependency();
        if (dependency == null) {
            return null;
        }
        String scope = dependency.getScope();
        if ("compile".equals(scope) || "system".equals(scope) || "provided".equals(scope)) {
            return "compile";
        }
        if ("runtime".equals(scope)) {
            return "runtime";
        }
        if ("test".equals(scope)) {
            return "test";
        }
        return null;
    }
}

