/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.gui.editor.ModificationInfoManager;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.ViewOptionsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class ViewOptionsController
extends BasePreferencesController {
    private ViewOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_VIEW_OPTIONS");
    }

    private void initGui() {
        this.panel = new ViewOptionsPanel();
        this.panel.templateActivator.addActionListener(e -> this.updateEnabledness());
        this.panel.viewSourceAllBold.addActionListener(e -> this.updateEnabledness());
        this.panel.variablesList.setModel(new DefaultComboBoxModel<String>(new Vector<String>(ModificationInfoManager.getModInfoVariables())));
        this.panel.variablesListND.setModel(new DefaultComboBoxModel<String>(new Vector<String>(ModificationInfoManager.getModInfoVariablesNoDate())));
        this.panel.insertButton.addActionListener(e -> this.panel.modInfoTemplate.replaceSelection(this.panel.variablesList.getSelectedItem().toString()));
        this.panel.insertButtonND.addActionListener(e -> this.panel.modInfoTemplateND.replaceSelection(this.panel.variablesListND.getSelectedItem().toString()));
    }

    @Override
    protected void initFromPrefs() {
        this.panel.viewSourceAllBold.setSelected(Preferences.isPreferenceDefault("view_option_source_all_bold", true));
        this.panel.viewSourceActiveBold.setSelected(Preferences.isPreferenceDefault("view_option_source_active_bold", true));
        this.panel.markFirstNonUnique.setSelected(Preferences.isPreference("view_option_unique_first"));
        this.panel.simplifyPPTooltips.setSelected(Preferences.isPreferenceDefault("view_option_ppt_simplify", true));
        this.panel.templateActivator.setSelected(Preferences.isPreference("view_option_template_active"));
        this.panel.modInfoTemplate.setText(Preferences.getPreferenceDefault("view_option_mod_info_template", "${creationId} - ${changedId} ${changedDate} ${changedTime}"));
        this.panel.modInfoTemplate.setCaretPosition(0);
        this.panel.modInfoTemplateND.setText(Preferences.getPreferenceDefault("view_option_mod_info_template_wo_date", "${creationId} - ${changedId}"));
        this.panel.modInfoTemplateND.setCaretPosition(0);
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        this.panel.viewSourceAllBold.setSelected(true);
        this.panel.viewSourceActiveBold.setSelected(true);
        this.panel.markFirstNonUnique.setSelected(Preferences.isPreference("view_option_unique_first"));
        this.panel.simplifyPPTooltips.setSelected(true);
        this.panel.templateActivator.setSelected(false);
        this.panel.modInfoTemplate.setText("${creationId} - ${changedId} ${changedDate} ${changedTime}");
        this.panel.modInfoTemplate.setCaretPosition(0);
        this.panel.modInfoTemplateND.setText("${creationId} - ${changedId}");
        this.panel.modInfoTemplateND.setCaretPosition(0);
        this.updateEnabledness();
    }

    private void updateEnabledness() {
        boolean templatesEnabled = this.panel.templateActivator.isSelected();
        this.panel.modInfoTemplate.setEnabled(templatesEnabled);
        this.panel.templateLabel.setEnabled(templatesEnabled);
        this.panel.variablesLabel.setEnabled(templatesEnabled);
        this.panel.variablesList.setEnabled(templatesEnabled);
        this.panel.insertButton.setEnabled(templatesEnabled);
        this.panel.modInfoTemplateND.setEnabled(templatesEnabled);
        this.panel.templateLabelND.setEnabled(templatesEnabled);
        this.panel.variablesLabelND.setEnabled(templatesEnabled);
        this.panel.variablesListND.setEnabled(templatesEnabled);
        this.panel.insertButtonND.setEnabled(templatesEnabled);
        boolean allBold = this.panel.viewSourceAllBold.isSelected();
        this.panel.viewSourceActiveBold.setEnabled(!allBold);
    }

    @Override
    public void persist() {
        Preferences.setPreference("view_option_source_all_bold", this.panel.viewSourceAllBold.isSelected());
        Preferences.setPreference("view_option_source_active_bold", this.panel.viewSourceActiveBold.isSelected());
        Preferences.setPreference("view_option_unique_first", this.panel.markFirstNonUnique.isSelected());
        Preferences.setPreference("view_option_ppt_simplify", this.panel.simplifyPPTooltips.isSelected());
        Preferences.setPreference("view_option_template_active", this.panel.templateActivator.isSelected());
        Preferences.setPreference("view_option_mod_info_template", this.panel.modInfoTemplate.getText());
        Preferences.setPreference("view_option_mod_info_template_wo_date", this.panel.modInfoTemplateND.getText());
        ModificationInfoManager.reset();
        SwingUtilities.invokeLater(Core.getEditor().getSettings()::updateViewPreferences);
    }
}

