/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NotNull;

public class RandomAccessInputStream
extends InputStream {
    private static final int DEFAULT_BUFSIZE = 4096;
    private final RandomAccessFile in;
    private final ByteBuffer byteBuffer;
    private final int bufsize;
    private long currentpos = 0L;
    private long startpos = -1L;
    private long endpos = -1L;
    private long mark = 0L;
    private FileChannel fileChannel;

    public RandomAccessInputStream(RandomAccessFile inFile, int bufsize) {
        this.in = inFile;
        this.bufsize = bufsize;
        this.fileChannel = inFile.getChannel();
        this.byteBuffer = ByteBuffer.allocate(bufsize);
    }

    public RandomAccessInputStream(RandomAccessFile inFile) {
        this(inFile, 4096);
    }

    public RandomAccessInputStream(String file, String mode) throws IOException {
        this(new RandomAccessFile(file, mode));
    }

    public final FileChannel getChannel() {
        return this.fileChannel;
    }

    @Override
    public final int available() throws IOException {
        long available = this.length() - this.position();
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
        this.fileChannel = null;
    }

    public final long length() throws IOException {
        return this.fileChannel.size();
    }

    public final int getLength() throws IOException {
        return (int)this.length();
    }

    public final long position() throws IOException {
        return this.currentpos;
    }

    @Deprecated
    public final int getPos() throws IOException {
        return (int)this.position();
    }

    @Override
    public final synchronized void mark(int markpos) {
        this.mark = this.currentpos;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized int read() throws IOException {
        int c = this.read(this.currentpos);
        if (c == -1) {
            return -1;
        }
        ++this.currentpos;
        return c;
    }

    public synchronized int read(long pos) {
        if (pos < this.startpos || pos > this.endpos) {
            long blockstart = pos / (long)this.bufsize * (long)this.bufsize;
            int n = 0;
            try {
                this.fileChannel.position(blockstart);
                this.byteBuffer.clear();
            }
            catch (IOException e) {
                return -1;
            }
            this.byteBuffer.flip();
            this.startpos = blockstart;
            this.endpos = blockstart + (long)(n += this.fileChannel.read(this.byteBuffer)) - 1L;
            if (pos < this.startpos || pos > this.endpos) {
                return -1;
            }
        }
        return this.byteBuffer.get((int)(pos - this.startpos)) & 0xFF;
    }

    @Override
    public final int read(byte @NotNull [] buf, int off, int len) throws IOException {
        if (this.currentpos < this.startpos || this.currentpos > this.endpos) {
            long blockstart = this.currentpos / (long)this.bufsize * (long)this.bufsize;
            long n = 0L;
            try {
                this.fileChannel.position(blockstart);
                this.byteBuffer.clear();
            }
            catch (IOException e) {
                return -1;
            }
            this.startpos = blockstart;
            this.endpos = blockstart + (n += (long)this.fileChannel.read(this.byteBuffer)) - 1L;
            if (this.currentpos < this.startpos || this.currentpos > this.endpos) {
                return -1;
            }
        }
        this.byteBuffer.position((int)(this.currentpos - this.startpos));
        int size = Math.min(Math.min(len, (int)(this.length() - this.currentpos)), this.byteBuffer.remaining());
        this.byteBuffer.get(buf, off, size);
        this.currentpos += (long)size;
        return size;
    }

    public final void readFully(byte[] buf) throws IOException {
        for (int offset = this.read(buf, 0, buf.length); offset < buf.length; offset += this.read(buf, offset, buf.length - offset)) {
        }
    }

    @Override
    public final synchronized void reset() {
        this.currentpos = this.mark;
    }

    public final void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("seek position is less than 0");
        }
        this.currentpos = Math.min(pos, this.length());
    }

    @Override
    public final long skip(long n) throws IOException {
        long previous = this.currentpos;
        this.currentpos = n < 0L && this.currentpos + n < 0L ? 0L : (this.currentpos + n > this.length() ? this.length() : (this.currentpos += n));
        return this.currentpos - previous;
    }
}

