/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;

public class SqlJetFileUtil {
    public static final int ATTEMPTS_COUNT = SqlJetUtility.getIntSysProp("sqljet.fs.win32_retry_count", 100);
    public static final SqlJetOsType OS = new SqlJetOsType();

    public static boolean deleteFile(File file) {
        return SqlJetFileUtil.deleteFile(file, false);
    }

    public static boolean deleteFile(File file, boolean sync) {
        if (file == null) {
            return true;
        }
        if (OS.isWindows()) {
            sync = true;
        }
        if (!sync || file.isDirectory() || !file.exists()) {
            return file.delete();
        }
        long sleep = 1L;
        for (int i = 0; i < ATTEMPTS_COUNT; ++i) {
            if (file.delete() && !file.exists()) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (sleep >= 128L) continue;
            sleep *= 2L;
        }
        return false;
    }

    public static RandomAccessFile openFile(File file, String mode) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (OS.isWindows()) {
            long sleep = 1L;
            for (int i = 0; i < ATTEMPTS_COUNT; ++i) {
                try {
                    return new RandomAccessFile(file, mode);
                }
                catch (FileNotFoundException e) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e1) {
                        return null;
                    }
                    if (sleep >= 128L) continue;
                    sleep *= 2L;
                    continue;
                }
            }
        }
        return new RandomAccessFile(file, mode);
    }

    private static boolean containsIgnoreCase(String s, String pattern) {
        assert (s != null && pattern != null);
        int length = pattern.length();
        assert (length > 0);
        for (int i = s.length() - length; i >= 0; --i) {
            if (!s.regionMatches(true, i, pattern, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static class SqlJetOsType {
        public boolean isWindows;
        public boolean isOS2;
        public boolean isOSX;
        public boolean isBSD;
        public boolean isLinux;
        public boolean isSolaris;
        public boolean isOpenVMS;
        public boolean is32Bit;
        public boolean is64Bit;

        public SqlJetOsType() {
            String osName = System.getProperty("os.name");
            boolean windows = osName != null && SqlJetFileUtil.containsIgnoreCase(osName, "windows");
            this.isOS2 = !windows && osName != null ? (windows = SqlJetFileUtil.containsIgnoreCase(osName, "os/2")) : false;
            this.isWindows = windows;
            this.isOSX = osName != null && (SqlJetFileUtil.containsIgnoreCase(osName, "mac") || SqlJetFileUtil.containsIgnoreCase(osName, "darwin"));
            this.isLinux = osName != null && (SqlJetFileUtil.containsIgnoreCase(osName, "linux") || SqlJetFileUtil.containsIgnoreCase(osName, "hp-ux"));
            this.isBSD = !this.isLinux && osName != null && SqlJetFileUtil.containsIgnoreCase(osName, "bsd");
            this.isSolaris = !this.isLinux && !this.isBSD && osName != null && (SqlJetFileUtil.containsIgnoreCase(osName, "solaris") || SqlJetFileUtil.containsIgnoreCase(osName, "sunos"));
            boolean bl = this.isOpenVMS = !this.isOSX && osName != null && SqlJetFileUtil.containsIgnoreCase(osName, "openvms");
            if (!(this.isWindows || this.isOSX || this.isLinux || this.isBSD || this.isSolaris || this.isOpenVMS || this.isOS2)) {
                this.isLinux = true;
            }
            this.is32Bit = "32".equals(System.getProperty("sun.arch.data.model", "32"));
            this.is64Bit = "64".equals(System.getProperty("sun.arch.data.model", "64"));
        }

        public boolean isWindows() {
            return this.isWindows;
        }

        public boolean isOS2() {
            return this.isOS2;
        }

        public boolean isOSX() {
            return this.isOSX;
        }

        public boolean isBSD() {
            return this.isBSD;
        }

        public boolean isLinux() {
            return this.isLinux;
        }

        public boolean isSolaris() {
            return this.isSolaris;
        }

        public boolean isOpenVMS() {
            return this.isOpenVMS;
        }

        public boolean is32Bit() {
            return this.is32Bit;
        }

        public boolean is64Bit() {
            return this.is64Bit;
        }
    }
}

