/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.dsl;

import io.github.eb4j.dsl.DslDictionary;
import io.github.eb4j.dsl.data.DictionaryData;
import io.github.eb4j.dsl.data.DslDictionaryProperty;
import io.github.eb4j.dsl.data.DslEntry;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;

public class DslZipDictionary
extends DslDictionary {
    private final DictZipInputStream dzis;

    public DslZipDictionary(Path path, DictionaryData<DslEntry> dictionaryData, DslDictionaryProperty prop) throws IOException {
        super(dictionaryData, prop);
        this.dzis = new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r")));
    }

    @Override
    String getRecord(long offset, int size) throws IOException {
        byte[] buf = new byte[size];
        this.dzis.seek(offset);
        this.dzis.readFully(buf);
        return new String(buf, this.prop.getCharset());
    }
}

