/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.macro;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.calculator.content.TranslationCalculator;
import net.loomchild.maligna.calculator.length.PoissonDistributionCalculator;
import net.loomchild.maligna.calculator.length.counter.SplitCounter;
import net.loomchild.maligna.calculator.meta.CompositeCalculator;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.Filter;
import net.loomchild.maligna.filter.aligner.Aligner;
import net.loomchild.maligna.filter.aligner.UnifyAligner;
import net.loomchild.maligna.filter.aligner.align.hmm.adaptive.AdaptiveBandAlgorithm;
import net.loomchild.maligna.filter.aligner.align.hmm.fb.ForwardBackwardAlgorithmFactory;
import net.loomchild.maligna.filter.macro.Macro;
import net.loomchild.maligna.filter.meta.CompositeFilter;
import net.loomchild.maligna.filter.modifier.Modifier;
import net.loomchild.maligna.filter.modifier.modify.clean.UnifyRareWordsCleanAlgorithm;
import net.loomchild.maligna.filter.modifier.modify.split.SplitAlgorithm;
import net.loomchild.maligna.filter.selector.FractionSelector;
import net.loomchild.maligna.filter.selector.OneToOneSelector;
import net.loomchild.maligna.model.vocabulary.Vocabulary;
import net.loomchild.maligna.model.vocabulary.VocabularyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MooreMacro
implements Macro {
    private static final Log log = LogFactory.getLog(MooreMacro.class);
    public static final float SELECT_FRACTION = 0.85f;

    @Override
    public List<Alignment> apply(List<Alignment> alignmentList) {
        List<Alignment> unifiedAlignmentList = this.unifyRareWords(alignmentList);
        List<Alignment> lengthAlignmentList = this.lengthAlign(unifiedAlignmentList);
        List<Alignment> bestAlignmentList = this.selectBestAlignments(lengthAlignmentList);
        if (bestAlignmentList.size() == 0) {
            log.warn((Object)"Content alignment is impossible because zero best alignments were selected from length alignment. Returning result of length alignment only.");
            return this.unifyAlignments(alignmentList, lengthAlignmentList);
        }
        List<Alignment> contentAlignmentList = this.contentAlign(unifiedAlignmentList, bestAlignmentList);
        return this.unifyAlignments(alignmentList, contentAlignmentList);
    }

    private List<Alignment> unifyRareWords(List<Alignment> alignmentList) {
        SplitAlgorithm splitAlgorithm = VocabularyUtil.DEFAULT_TOKENIZE_ALGORITHM;
        Vocabulary sourceVocabulary = new Vocabulary();
        Vocabulary targetVocabulary = new Vocabulary();
        ArrayList<List<Integer>> sourceWidList = new ArrayList<List<Integer>>();
        ArrayList<List<Integer>> targetWidList = new ArrayList<List<Integer>>();
        VocabularyUtil.tokenize(splitAlgorithm, alignmentList, sourceVocabulary, targetVocabulary, sourceWidList, targetWidList);
        sourceVocabulary = VocabularyUtil.createTruncatedVocabulary(sourceWidList, sourceVocabulary);
        targetVocabulary = VocabularyUtil.createTruncatedVocabulary(targetWidList, targetVocabulary);
        UnifyRareWordsCleanAlgorithm sourceAlgorithm = new UnifyRareWordsCleanAlgorithm(sourceVocabulary);
        UnifyRareWordsCleanAlgorithm targetAlgorithm = new UnifyRareWordsCleanAlgorithm(targetVocabulary);
        Modifier filter = new Modifier(sourceAlgorithm, targetAlgorithm);
        return filter.apply(alignmentList);
    }

    private List<Alignment> lengthAlign(List<Alignment> alignmentList) {
        SplitCounter counter = new SplitCounter();
        PoissonDistributionCalculator calculator = new PoissonDistributionCalculator(counter, alignmentList);
        ForwardBackwardAlgorithmFactory algorithmFactory = new ForwardBackwardAlgorithmFactory();
        AdaptiveBandAlgorithm algorithm = new AdaptiveBandAlgorithm(algorithmFactory, calculator);
        Aligner filter = new Aligner(algorithm);
        return filter.apply(alignmentList);
    }

    private List<Alignment> selectBestAlignments(List<Alignment> alignmentList) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        filterList.add(new OneToOneSelector());
        filterList.add(new FractionSelector(0.85f));
        CompositeFilter filter = new CompositeFilter(filterList);
        return filter.apply(alignmentList);
    }

    private List<Alignment> contentAlign(List<Alignment> alignmentList, List<Alignment> bestAlignmentList) {
        ArrayList<Calculator> calculatorList = new ArrayList<Calculator>();
        SplitCounter counter = new SplitCounter();
        calculatorList.add(new PoissonDistributionCalculator(counter, alignmentList));
        calculatorList.add(new TranslationCalculator(bestAlignmentList));
        CompositeCalculator calculator = new CompositeCalculator(calculatorList);
        ForwardBackwardAlgorithmFactory algorithmFactory = new ForwardBackwardAlgorithmFactory();
        AdaptiveBandAlgorithm algorithm = new AdaptiveBandAlgorithm(algorithmFactory, calculator);
        Aligner filter = new Aligner(algorithm);
        return filter.apply(alignmentList);
    }

    private List<Alignment> unifyAlignments(List<Alignment> alignmentList, List<Alignment> referenceAlignmentList) {
        UnifyAligner filter = new UnifyAligner(referenceAlignmentList);
        return filter.apply(alignmentList);
    }
}

