/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;

public class UsernameTokenSignedAction
implements Action {
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        String password = handler.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setWsConfig(reqData.getWssConfig());
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.setUserInfo(reqData.getUsername(), password);
        builder.addCreated();
        builder.addNonce();
        builder.prepare(doc);
        WSSecSignature sign = new WSSecSignature();
        sign.setWsConfig(reqData.getWssConfig());
        if (reqData.getSignatureParts().size() > 0) {
            sign.setParts(reqData.getSignatureParts());
        }
        sign.setUsernameToken(builder);
        sign.setKeyIdentifierType(7);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        try {
            sign.build(doc, null, reqData.getSecHeader());
            reqData.getSignatureValues().add(sign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Error during Signatur with UsernameToken secret" + e);
        }
        builder.prependToHeader(reqData.getSecHeader());
    }
}

