/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EnumSet;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.DrawOption;
import org.diylc.common.IPlugInPort;
import org.diylc.swingframework.IDrawingProvider;

public class ProjectDrawingProvider
implements IDrawingProvider {
    private IPlugInPort plugInPort;
    private boolean useZoom;
    private boolean showGridWhenNeeded;

    public ProjectDrawingProvider(IPlugInPort iPlugInPort, boolean bl, boolean bl2) {
        this.plugInPort = iPlugInPort;
        this.useZoom = bl;
        this.showGridWhenNeeded = bl2;
    }

    public Dimension getSize() {
        return this.plugInPort.getCanvasDimensions(this.useZoom);
    }

    public void draw(int n, Graphics graphics) {
        EnumSet<DrawOption> enumSet = EnumSet.of(DrawOption.ANTIALIASING);
        if (this.useZoom) {
            enumSet.add(DrawOption.ZOOM);
        }
        if (this.showGridWhenNeeded && ConfigurationManager.getInstance().readBoolean("exportGrid", false)) {
            enumSet.add(DrawOption.GRID);
        }
        if (ConfigurationManager.getInstance().readBoolean("outline", false)) {
            enumSet.add(DrawOption.OUTLINE_MODE);
        }
        this.plugInPort.draw((Graphics2D)graphics, enumSet, null);
    }

    public int getPageCount() {
        return 1;
    }
}

