/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.transport.SimpleClient;

public abstract class SchemaStatement
extends Operation {
    final PreparedStatement statement;
    final Integer thriftId;
    final ConsistencyLevel cl;
    final int[] argumentIndex;
    final Object[] bindBuffer;
    final ColumnDefinitions definitions;

    public SchemaStatement(Timer timer, StressSettings settings, Operation.DataSpec spec, PreparedStatement statement, Integer thriftId, ConsistencyLevel cl) {
        super(timer, settings, spec);
        this.statement = statement;
        this.thriftId = thriftId;
        this.cl = cl;
        this.argumentIndex = new int[statement.getVariables().size()];
        this.bindBuffer = new Object[this.argumentIndex.length];
        this.definitions = statement.getVariables();
        int i = 0;
        for (ColumnDefinitions.Definition definition : this.definitions) {
            this.argumentIndex[i++] = spec.partitionGenerator.indexOf(definition.getName());
        }
        statement.setConsistencyLevel(JavaDriverClient.from(cl));
    }

    BoundStatement bindRow(Row row) {
        for (int i = 0; i < this.argumentIndex.length; ++i) {
            Object value = row.get(this.argumentIndex[i]);
            if (this.definitions.getType(i).getName().equals((Object)DataType.date().getName())) {
                value = LocalDate.fromDaysSinceEpoch((int)((Integer)value));
            }
            this.bindBuffer[i] = value;
            if (this.bindBuffer[i] != null || this.spec.partitionGenerator.permitNulls(this.argumentIndex[i])) continue;
            throw new IllegalStateException();
        }
        return this.statement.bind(this.bindBuffer);
    }

    List<ByteBuffer> thriftRowArgs(Row row) {
        ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>();
        for (int i : this.argumentIndex) {
            args.add(this.spec.partitionGenerator.convert(i, row.get(i)));
        }
        return args;
    }

    @Override
    public void run(SimpleClient client) throws IOException {
        throw new UnsupportedOperationException();
    }

    abstract class Runner
    implements Operation.RunOp {
        int partitionCount;
        int rowCount;

        Runner() {
        }

        @Override
        public int partitionCount() {
            return this.partitionCount;
        }

        @Override
        public int rowCount() {
            return this.rowCount;
        }
    }
}

