/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.net.SocketException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.HeapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JVMStabilityInspector {
    private static final Logger logger = LoggerFactory.getLogger(JVMStabilityInspector.class);
    private static Killer killer = new Killer();
    private static Object lock = new Object();
    private static boolean printingHeapHistogram;

    private JVMStabilityInspector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inspectThrowable(Throwable t) {
        boolean isUnstable = false;
        if (t instanceof OutOfMemoryError) {
            if (Boolean.getBoolean("cassandra.printHeapHistogramOnOutOfMemoryError")) {
                Object object = lock;
                synchronized (object) {
                    if (printingHeapHistogram) {
                        return;
                    }
                    printingHeapHistogram = true;
                }
                HeapUtils.logHeapHistogram();
            }
            logger.error("OutOfMemory error letting the JVM handle the error:", t);
            StorageService.instance.removeShutdownHook();
            throw (OutOfMemoryError)t;
        }
        if (DatabaseDescriptor.getDiskFailurePolicy() == Config.DiskFailurePolicy.die && (t instanceof FSError || t instanceof CorruptSSTableException)) {
            isUnstable = true;
        }
        if ((t instanceof FileNotFoundException || t instanceof SocketException) && t.getMessage().contains("Too many open files")) {
            isUnstable = true;
        }
        if (isUnstable) {
            killer.killCurrentJVM(t);
        }
        if (t.getCause() != null) {
            JVMStabilityInspector.inspectThrowable(t.getCause());
        }
    }

    public static void inspectCommitLogThrowable(Throwable t) {
        if (!StorageService.instance.isSetupCompleted()) {
            logger.error("Exiting due to error while processing commit log during initialization.", t);
            killer.killCurrentJVM(t, true);
        } else if (DatabaseDescriptor.getCommitFailurePolicy() == Config.CommitFailurePolicy.die) {
            killer.killCurrentJVM(t);
        } else {
            JVMStabilityInspector.inspectThrowable(t);
        }
    }

    public static void killCurrentJVM(Throwable t, boolean quiet) {
        killer.killCurrentJVM(t, quiet);
    }

    @VisibleForTesting
    public static Killer replaceKiller(Killer newKiller) {
        Killer oldKiller = killer;
        killer = newKiller;
        return oldKiller;
    }

    @VisibleForTesting
    public static class Killer {
        protected void killCurrentJVM(Throwable t) {
            this.killCurrentJVM(t, false);
        }

        protected void killCurrentJVM(Throwable t, boolean quiet) {
            if (!quiet) {
                t.printStackTrace(System.err);
                logger.error("JVM state determined to be unstable.  Exiting forcefully due to:", t);
            }
            StorageService.instance.removeShutdownHook();
            System.exit(100);
        }
    }
}

