/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.utils.concurrent.WaitQueue;

class PeriodicCommitLogService
extends AbstractCommitLogService {
    private static final int blockWhenSyncLagsMillis = (int)((double)DatabaseDescriptor.getCommitLogSyncPeriod() * 1.5);

    public PeriodicCommitLogService(CommitLog commitLog) {
        super(commitLog, "PERIODIC-COMMIT-LOG-SYNCER", DatabaseDescriptor.getCommitLogSyncPeriod());
    }

    @Override
    protected void maybeWaitForSync(CommitLogSegment.Allocation alloc) {
        if (this.waitForSyncToCatchUp(Long.MAX_VALUE)) {
            long started = System.currentTimeMillis();
            this.pending.incrementAndGet();
            while (this.waitForSyncToCatchUp(started)) {
                WaitQueue.Signal signal = this.syncComplete.register(this.commitLog.metrics.waitingOnCommit.time());
                if (this.waitForSyncToCatchUp(started)) {
                    signal.awaitUninterruptibly();
                    continue;
                }
                signal.cancel();
            }
            this.pending.decrementAndGet();
        }
    }

    private boolean waitForSyncToCatchUp(long started) {
        return started > this.lastSyncedAt + (long)blockWhenSyncLagsMillis;
    }
}

