/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.ArrayList;

public class MediaTracker
implements Serializable {
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETE = 8;
    static final long serialVersionUID = -483174189758638095L;
    Component target;
    MediaEntry head;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addImage(Image image, int id) {
        MediaEntry e = new MediaEntry();
        e.id = id;
        e.image = image;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            e.next = this.head;
            this.head = e;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addImage(Image image, int id, int width, int height) {
        MediaEntry e = new MediaEntry();
        e.id = id;
        e.image = image;
        e.width = width;
        e.height = height;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            e.next = this.head;
            this.head = e;
            return;
        }
    }

    public boolean checkAll() {
        return this.checkAll(false);
    }

    public boolean checkAll(boolean load) {
        MediaEntry e = this.head;
        boolean result = true;
        while (e != null) {
            if ((e.status & 0xE) == 0) {
                if (load && (e.status & 1) == 0) {
                    boolean complete;
                    if (this.target.prepareImage(e.image, e)) {
                        e.status = 8;
                    } else {
                        e.status = 1;
                        int flags = this.target.checkImage(e.image, e);
                        if ((flags & 0x80) != 0) {
                            e.status = 2;
                        } else if ((flags & 0x40) != 0) {
                            e.status = 4;
                        } else if ((flags & 0x20) != 0) {
                            e.status = 8;
                        }
                    }
                    boolean bl = false;
                    if ((e.status & 0xE) != 0) {
                        bl = true;
                    }
                    if (!(complete = bl)) {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
            e = e.next;
        }
        return result;
    }

    public boolean isErrorAny() {
        MediaEntry e = this.head;
        while (e != null) {
            if ((e.status & 4) != 0) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object[] getErrorsAny() {
        MediaEntry e = this.head;
        ArrayList result = null;
        while (e != null) {
            if ((e.status & 4) != 0) {
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(e.image);
            }
            e = e.next;
        }
        if (result == null) {
            return null;
        }
        return result.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForAll() throws InterruptedException {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!this.checkAll(true)) {
                this.wait();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForAll(long ms) throws InterruptedException {
        long start = System.currentTimeMillis();
        boolean result = this.checkAll(true);
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!result) {
                this.wait(ms);
                result = this.checkAll(true);
                if (System.currentTimeMillis() - start <= ms) continue;
            }
            return result;
        }
    }

    public int statusAll(boolean load) {
        int result = 0;
        MediaEntry e = this.head;
        while (e != null) {
            if (load && e.status == 0) {
                if (this.target.prepareImage(e.image, e)) {
                    e.status = 8;
                } else {
                    e.status = 1;
                    int flags = this.target.checkImage(e.image, e);
                    if ((flags & 0x80) != 0) {
                        e.status = 2;
                    } else if ((flags & 0x40) != 0) {
                        e.status = 4;
                    } else if ((flags & 0x20) != 0) {
                        e.status = 8;
                    }
                }
            }
            result |= e.status;
            e = e.next;
        }
        return result;
    }

    public boolean checkID(int id) {
        return this.checkID(id, false);
    }

    public boolean checkID(int id, boolean load) {
        MediaEntry e = this.head;
        boolean result = true;
        while (e != null) {
            if (e.id == id && (e.status & 0xE) == 0) {
                if (load && (e.status & 1) == 0) {
                    boolean complete;
                    e.status = 1;
                    if (this.target.prepareImage(e.image, e)) {
                        e.status = 8;
                    } else {
                        int flags = this.target.checkImage(e.image, e);
                        if ((flags & 0x80) != 0) {
                            e.status = 2;
                        } else if ((flags & 0x40) != 0) {
                            e.status = 4;
                        } else if ((flags & 0x20) != 0) {
                            e.status = 8;
                        }
                    }
                    boolean bl = false;
                    if ((e.status & 0xE) != 0) {
                        bl = true;
                    }
                    if (!(complete = bl)) {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
            e = e.next;
        }
        return result;
    }

    public boolean isErrorID(int id) {
        MediaEntry e = this.head;
        while (e != null) {
            if (e.id == id && (e.status & 4) != 0) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object[] getErrorsID(int id) {
        MediaEntry e = this.head;
        ArrayList result = null;
        while (e != null) {
            if (e.id == id && (e.status & 4) != 0) {
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(e.image);
            }
            e = e.next;
        }
        if (result == null) {
            return null;
        }
        return result.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForID(int id) throws InterruptedException {
        MediaEntry e = this.head;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!this.checkID(id, true)) {
                this.wait();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForID(int id, long ms) throws InterruptedException {
        MediaEntry e = this.head;
        long start = System.currentTimeMillis();
        boolean result = this.checkID(id, true);
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!result) {
                this.wait(ms);
                result = this.checkID(id, true);
                if (System.currentTimeMillis() - start <= ms) continue;
            }
            return result;
        }
    }

    public int statusID(int id, boolean load) {
        int result = 0;
        MediaEntry e = this.head;
        while (e != null) {
            if (e.id == id) {
                if (load && e.status == 0) {
                    if (this.target.prepareImage(e.image, e)) {
                        e.status = 8;
                    } else {
                        e.status = 1;
                        int flags = this.target.checkImage(e.image, e);
                        if ((flags & 0x80) != 0) {
                            e.status = 2;
                        } else if ((flags & 0x40) != 0) {
                            e.status = 4;
                        } else if ((flags & 0x20) != 0) {
                            e.status = 8;
                        }
                    }
                }
                result |= e.status;
            }
            e = e.next;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeImage(Image image) {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            MediaEntry e = this.head;
            MediaEntry prev = null;
            while (e != null) {
                if (e.image == image) {
                    if (prev == null) {
                        this.head = e.next;
                    } else {
                        prev.next = e.next;
                    }
                }
                prev = e;
                e = e.next;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeImage(Image image, int id) {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            MediaEntry e = this.head;
            MediaEntry prev = null;
            while (e != null) {
                if (e.id == id && e.image == image) {
                    if (prev == null) {
                        this.head = e.next;
                    } else {
                        prev.next = e.next;
                    }
                } else {
                    prev = e;
                }
                e = e.next;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeImage(Image image, int id, int width, int height) {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            MediaEntry e = this.head;
            MediaEntry prev = null;
            while (e != null) {
                if (e.id == id && e.image == image && e.width == width && e.height == height) {
                    if (prev == null) {
                        this.head = e.next;
                    } else {
                        prev.next = e.next;
                    }
                } else {
                    prev = e;
                }
                e = e.next;
            }
            return;
        }
    }

    public MediaTracker(Component c) {
        this.target = c;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MediaEntry
    implements ImageObserver {
        int id;
        Image image;
        MediaEntry next;
        int status;
        int width;
        int height;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            this.status = (flags & 0x80) != 0 ? 2 : ((flags & 0x40) != 0 ? 4 : ((flags & 0x20) != 0 ? 8 : 0));
            MediaTracker mediaTracker = MediaTracker.this;
            synchronized (mediaTracker) {
                MediaTracker.this.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var7_7
                boolean bl = false;
                if ((this.status & 0xE) != 0) return bl;
                return true;
            }
        }

        MediaEntry() {
        }
    }
}

