/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Menu
extends MenuItem
implements MenuContainer,
Serializable {
    private static final long serialVersionUID = -8809584163345499784L;
    static final transient String separatorLabel = "-";
    private Vector items;
    private boolean tearOff;
    private boolean isHelpMenu;
    private int menuSerializedDataVersion;

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int index) {
        return (MenuItem)this.items.elementAt(index);
    }

    public MenuItem add(MenuItem item) {
        this.items.addElement(item);
        if (item.parent != null) {
            item.parent.remove(item);
        }
        item.parent = this;
        if (this.peer != null) {
            MenuPeer mp = (MenuPeer)this.peer;
            mp.addItem(item);
        }
        return item;
    }

    public void add(String label) {
        this.add(new MenuItem(label));
    }

    public void insert(MenuItem item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index is less than zero");
        }
        MenuPeer peer = (MenuPeer)this.getPeer();
        if (peer == null) {
            return;
        }
        int count = this.getItemCount();
        if (index >= count) {
            peer.addItem(item);
        } else {
            int i = count - 1;
            while (i >= index) {
                peer.delItem(i);
                --i;
            }
            peer.addItem(item);
            i = index;
            while (i < count) {
                peer.addItem((MenuItem)this.items.elementAt(i));
                ++i;
            }
        }
        this.items.insertElementAt(item, index);
    }

    public void insert(String label, int index) {
        this.insert(new MenuItem(label), index);
    }

    public void addSeparator() {
        this.add(new MenuItem(separatorLabel));
    }

    public void insertSeparator(int index) {
        this.insert(new MenuItem(separatorLabel), index);
    }

    public synchronized void remove(int index) {
        this.items.removeElementAt(index);
        MenuPeer mp = (MenuPeer)this.getPeer();
        if (mp != null) {
            mp.delItem(index);
        }
    }

    public void remove(MenuComponent item) {
        int index = this.items.indexOf(item);
        if (index == -1) {
            return;
        }
        this.remove(index);
    }

    public synchronized void removeAll() {
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            this.remove(0);
            ++i;
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createMenu(this);
        }
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            MenuItem mi = (MenuItem)e.nextElement();
            mi.addNotify();
        }
        super.addNotify();
    }

    public void removeNotify() {
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            MenuItem mi = (MenuItem)e.nextElement();
            mi.removeNotify();
        }
        super.removeNotify();
    }

    public String paramString() {
        return ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    private final /* synthetic */ void this() {
        this.items = new Vector();
        this.menuSerializedDataVersion = 1;
    }

    public Menu() {
        this.this();
    }

    public Menu(String label) {
        this(label, false);
    }

    public Menu(String label, boolean isTearOff) {
        super(label);
        this.this();
        this.tearOff = isTearOff;
        if (label.equals("Help")) {
            this.isHelpMenu = true;
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private static final long serialVersionUID = 5228160894980069094L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        protected AccessibleAWTMenu() {
        }
    }
}

