/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.VMAccessController;

public final class AccessController {
    public static final void checkPermission(Permission perm) throws AccessControlException {
        AccessController.getContext().checkPermission(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object doPrivileged(PrivilegedAction action) {
        Object object;
        VMAccessController.pushContext(null);
        try {
            object = action.run();
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object doPrivileged(PrivilegedAction action, AccessControlContext context) {
        Object object;
        VMAccessController.pushContext(context);
        try {
            object = action.run();
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object doPrivileged(PrivilegedExceptionAction action) throws PrivilegedActionException {
        Object object;
        VMAccessController.pushContext(null);
        try {
            try {
                object = action.run();
                Object var2_2 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object doPrivileged(PrivilegedExceptionAction action, AccessControlContext context) throws PrivilegedActionException {
        Object object;
        VMAccessController.pushContext(context);
        try {
            try {
                object = action.run();
                Object var3_3 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    public static final AccessControlContext getContext() {
        return VMAccessController.getContext();
    }

    private AccessController() {
    }
}

