/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.provider.GnuDHPublicKey;
import gnu.javax.crypto.GnuDHPrivateKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DiffieHellmanKeyPairGeneratorImpl
extends KeyPairGeneratorSpi {
    private SecureRandom random;
    private DHParameterSpec params;

    public KeyPair generateKeyPair() {
        if (this.params == null || this.random == null) {
            throw new IllegalStateException("not initialized");
        }
        byte[] buf = new byte[this.params.getP().bitLength() >>> 3];
        this.random.nextBytes(buf);
        BigInteger x = new BigInteger(1, buf);
        BigInteger y = this.params.getG().modPow(x, this.params.getP());
        GnuDHPublicKey pub = new GnuDHPublicKey(this.params, y, null);
        GnuDHPrivateKey priv = new GnuDHPrivateKey(x, this.params);
        return new KeyPair(pub, priv);
    }

    public void initialize(int keysize, SecureRandom random) {
        throw new UnsupportedOperationException("key generation without parameters not supported");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) {
        if (!(params instanceof DHParameterSpec)) {
            throw new IllegalArgumentException("expecting Diffie-Hellman parameters");
        }
        this.params = (DHParameterSpec)params;
        this.random = random;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }
}

