/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class RelationalExpr
extends Expr {
    final Expr lhs;
    final Expr rhs;
    final boolean lt;
    final boolean eq;

    public final Object evaluate(Node context, int pos, int len) {
        Object left = this.lhs.evaluate(context, pos, len);
        Object right = this.rhs.evaluate(context, pos, len);
        double ln = RelationalExpr._number(context, left);
        double rn = RelationalExpr._number(context, right);
        if (this.eq && ln == rn) {
            return Boolean.TRUE;
        }
        if (this.lt ? ln < rn || Double.isInfinite(rn) : ln > rn || Double.isInfinite(ln)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public final Expr clone(Object context) {
        return new RelationalExpr(this.lhs.clone(context), this.rhs.clone(context), this.lt, this.eq);
    }

    public final boolean references(QName var) {
        boolean bl = false;
        if (this.lhs.references(var) || this.rhs.references(var)) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        return this.lhs + ' ' + (this.lt ? "<" : ">") + (this.eq ? "=" : "") + ' ' + this.rhs;
    }

    RelationalExpr(Expr lhs, Expr rhs, boolean lt, boolean eq) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.lt = lt;
        this.eq = eq;
    }
}

