/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CertificatePolicies
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.32");
    private final List policies;
    private final Map policyQualifierInfos;
    static /* synthetic */ Class class$gnu$java$security$x509$ext$CertificatePolicies;

    public List getPolicies() {
        return this.policies;
    }

    public List getPolicyQualifierInfos(OID oid) {
        return (List)this.policyQualifierInfos.get(oid);
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList pol = new ArrayList(this.policies.size());
            Iterator it = this.policies.iterator();
            while (it.hasNext()) {
                OID policy = (OID)it.next();
                List qualifiers = this.getPolicyQualifierInfos(policy);
                int n = 0;
                if (qualifiers == null) {
                    n = 1;
                }
                ArrayList l = new ArrayList(2 - n);
                l.add(new DERValue(6, policy));
                if (qualifiers != null) {
                    ArrayList ll = new ArrayList(qualifiers.size());
                    Iterator it2 = qualifiers.iterator();
                    while (it.hasNext()) {
                        PolicyQualifierInfo info = (PolicyQualifierInfo)it2.next();
                        try {
                            ll.add(DERReader.read(info.getEncoded()));
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    l.add(new DERValue(48, ll));
                }
                pol.add(new DERValue(48, l));
            }
            this.encoded = new DERValue(48, pol).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$java$security$x509$ext$CertificatePolicies;
        if (clazz == null) {
            clazz = class$gnu$java$security$x509$ext$CertificatePolicies = CertificatePolicies.class("[Lgnu.java.security.x509.ext.CertificatePolicies;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ policies=").append(this.policies).append(" policyQualifierInfos=").append(this.policyQualifierInfos).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public CertificatePolicies(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue pol = der.read();
        if (!pol.isConstructed()) {
            throw new IOException("malformed CertificatePolicies");
        }
        int len = 0;
        LinkedList policyList = new LinkedList();
        HashMap qualifierMap = new HashMap();
        while (len < pol.getLength()) {
            DERValue policyInfo = der.read();
            if (!policyInfo.isConstructed()) {
                throw new IOException("malformed PolicyInformation");
            }
            DERValue val = der.read();
            if (val.getTag() != 6) {
                throw new IOException("malformed CertPolicyId");
            }
            OID policyId = (OID)val.getValue();
            policyList.add(policyId);
            if (val.getEncodedLength() < policyInfo.getLength()) {
                DERValue qual = der.read();
                int len2 = 0;
                LinkedList quals = new LinkedList();
                while (len2 < qual.getLength()) {
                    val = der.read();
                    quals.add(new PolicyQualifierInfo(val.getEncoded()));
                    der.skip(val.getLength());
                    len2 += val.getEncodedLength();
                }
                qualifierMap.put(policyId, quals);
            }
            len += policyInfo.getEncodedLength();
        }
        this.policies = Collections.unmodifiableList(policyList);
        this.policyQualifierInfos = Collections.unmodifiableMap(qualifierMap);
    }

    public CertificatePolicies(List policies, Map policyQualifierInfos) {
        Iterator it = policies.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof OID) continue;
            throw new IllegalArgumentException("policies must be OIDs");
        }
        it = policyQualifierInfos.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            if (!(e.getKey() instanceof OID) || !policies.contains(e.getKey())) {
                throw new IllegalArgumentException("policyQualifierInfos keys must be OIDs");
            }
            if (!(e.getValue() instanceof List)) {
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
            Iterator it2 = ((List)e.getValue()).iterator();
            while (it.hasNext()) {
                if (it2.next() instanceof PolicyQualifierInfo) continue;
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
        }
        this.policies = Collections.unmodifiableList(new ArrayList(policies));
        this.policyQualifierInfos = Collections.unmodifiableMap(new HashMap(policyQualifierInfos));
    }
}

