/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineInputStream
extends FilterInputStream {
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private String encoding;
    private boolean eof;
    private final boolean blockReads;

    public String readLine() throws IOException {
        if (this.eof) {
            return null;
        }
        while (true) {
            if (this.blockReads) {
                int MAX_LENGTH = 1024;
                int len = this.in.available();
                if (len == 0 || len > 1024) {
                    len = 1024;
                }
                byte[] b = new byte[len];
                this.in.mark(len);
                len = this.in.read(b, 0, len);
                if (len == -1) {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                    return this.buf.toString(this.encoding);
                }
                int pos = this.indexOf(b, len, (byte)10);
                if (pos != -1) {
                    this.buf.write(b, 0, pos);
                    this.in.reset();
                    ++pos;
                    while (pos > 0) {
                        len = this.in.read(b, 0, pos);
                        int n = pos = len == -1 ? -1 : pos - len;
                    }
                    String ret = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return ret;
                }
                this.buf.write(b, 0, len);
                continue;
            }
            int c = this.in.read();
            switch (c) {
                case -1: {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                }
                case 10: {
                    String ret = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return ret;
                }
            }
            this.buf.write(c);
        }
    }

    private final int indexOf(byte[] b, int len, byte c) {
        int pos = 0;
        while (pos < len) {
            if (b[pos] == c) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public LineInputStream(InputStream in) {
        this(in, "US-ASCII");
    }

    public LineInputStream(InputStream in, String encoding) {
        super(in);
        this.encoding = encoding;
        this.eof = false;
        boolean bl = false;
        if (!(in instanceof BufferedInputStream) && in.markSupported()) {
            bl = true;
        }
        this.blockReads = bl;
    }
}

