greek-inputenc
==============

Input encoding definition files for the Greek script.

This package extends *UTF-8* support for 8-bit TeX engines to include
Greek letters and symbols.
It also provides definitions for the legacy
[iso-8859-7](https://en.wikipedia.org/wiki/ISO/IEC_8859-7) and
[macgreek](https://en.wikipedia.org/wiki/MacGreek_encoding) encodings.

**Version**: 1.9

**Copyright**: © 1999 Dimitrios Filippou,
               © 2000 Apostolos Syropoulos,
               © 2013 - 2023 Günter Milde

**License**:
  This work may be distributed and/or modified under the conditions of the
  [LaTeX Project Public License](http://www.latex-project.org/lppl.txt),
  either version 1.3 of this license or any later version.

**Home**: <https://codeberg.org/milde/greek-tex>

**Latest Release**: <https://ctan.org/pkg/greek-inputenc>


Usage
-----

Use [Babel's ``greek`` option](https://ctan.org/pkg/babel-greek),
[textalpha][textalpha.sty], or [alphabeta][alphabeta.sty]
to activate support for the Greek script in text. By default,
this loads the definitions for UTF-8 encoded Greek characters.

See the **documentation** for caveats, alternatives, and details:

* [greek-inputenc-doc.html](http://mirrors.ctan.org/language/greek/greek-inputenc/greek-inputenc-doc.html)
  (🡥CTAN)
* [greek-inputenc-doc.rst](https://codeberg.org/milde/greek-tex/src/branch/master/greek-inputenc/greek-inputenc-doc.rst)
  (🡥codeberg.org)
* `texdoc greek-inputenc` (local TeXLive installation)

[textalpha.sty]: http://mirrors.ctan.org/language/greek/greek-fontenc/textalpha.sty.html
[alphabeta.sty]: http://mirrors.ctan.org/language/greek/greek-fontenc/alphabeta.sty.html
