/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public final class MDFloatArray
extends MDAbstractArray<Float> {
    private static final long serialVersionUID = 1L;
    private float[] flattenedArray;

    public MDFloatArray(long[] dimensions) {
        this(new float[MDFloatArray.getLength(dimensions, 0L)], MDFloatArray.toInt(dimensions), false);
    }

    public MDFloatArray(long[] dimensions, long capacityHyperRows) {
        this(new float[MDFloatArray.getLength(dimensions, capacityHyperRows)], MDFloatArray.toInt(dimensions), false);
    }

    public MDFloatArray(float[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDFloatArray.toInt(dimensions), true);
    }

    public MDFloatArray(float[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDFloatArray.toInt(dimensions), checkdimensions);
    }

    public MDFloatArray(int[] dimensions) {
        this(new float[MDFloatArray.getLength(dimensions, 0)], dimensions, false);
    }

    public MDFloatArray(int[] dimensions, int capacityHyperRows) {
        this(new float[MDFloatArray.getLength(dimensions, capacityHyperRows)], dimensions, false);
    }

    public MDFloatArray(float[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDFloatArray(float[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDFloatArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    public MDFloatArray(float[][] matrix) {
        this(matrix, MDFloatArray.getDimensions(matrix));
    }

    public MDFloatArray(float[][] matrix, int[] dimensions) {
        super(dimensions, 0, matrix.length);
        int sizeX = dimensions[0];
        int sizeY = dimensions[1];
        int length = MDFloatArray.getLength(dimensions, 0);
        this.flattenedArray = new float[length];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(matrix[i], 0, this.flattenedArray, i * sizeY, sizeY);
            ++i;
        }
    }

    private static int[] getDimensions(float[][] matrix) {
        assert (matrix != null);
        return new int[]{matrix.length, matrix.length == 0 ? 0 : matrix[0].length};
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public Float getAsObject(int ... indices) {
        return Float.valueOf(this.get(indices));
    }

    @Override
    public void setToObject(Float value, int ... indices) {
        this.set(value.floatValue(), indices);
    }

    @Override
    public Float getAsObject(int linearIndex) {
        return Float.valueOf(this.get(linearIndex));
    }

    @Override
    public void setToObject(Float value, int linearIndex) {
        this.set(value.floatValue(), linearIndex);
    }

    public float[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public float[] getCopyAsFlatArray() {
        return ArrayUtils.subarray(this.flattenedArray, 0, this.dimensions[0] * this.hyperRowLength);
    }

    @Override
    protected void adaptCapacityHyperRows() {
        float[] oldArray = this.flattenedArray;
        this.flattenedArray = new float[this.capacityHyperRows * this.hyperRowLength];
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    public float get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public float get(int index) {
        return this.flattenedArray[index];
    }

    public float get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public float get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(float value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(float value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(float value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(float value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public float[][] toMatrix() {
        int sizeX = this.dimensions[0];
        int sizeY = this.dimensions[1];
        float[][] result = new float[sizeX][sizeY];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(this.flattenedArray, i * sizeY, result[i], 0, sizeY);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDFloatArray other = (MDFloatArray)obj;
        if (!Arrays.equals(this.getValuesAsFlatArray(), other.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private float[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }
}

