/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.ls.ReaderInputStream;
import gnu.xml.transform.ErrorListenerErrorHandler;
import gnu.xml.transform.URIResolverEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class XSLURIResolver
implements URIResolver {
    Map lastModifiedCache;
    Map nodeCache;
    DocumentBuilder builder;
    URIResolver userResolver;
    ErrorListener userListener;

    void setUserResolver(URIResolver userResolver) {
        this.userResolver = userResolver;
    }

    void setUserListener(ErrorListener userListener) {
        this.userListener = userListener;
    }

    void flush() {
        this.lastModifiedCache.clear();
        this.nodeCache.clear();
    }

    public Source resolve(String href, String base) throws TransformerException {
        Source source = null;
        if (this.userResolver != null) {
            source = this.userResolver.resolve(base, href);
        }
        return this.resolveDOM(source, href, base);
    }

    DOMSource resolveDOM(Source source, String base, String href) throws TransformerException {
        if (source != null && source instanceof DOMSource) {
            return (DOMSource)source;
        }
        String systemId = source == null ? null : source.getSystemId();
        long lastModified = 0L;
        long lastLastModified = 0L;
        try {
            Reader reader;
            StreamSource ss;
            URL url = this.resolveURL(systemId, base, href);
            Node node2 = null;
            InputStream in = null;
            if (source instanceof StreamSource && (in = (ss = (StreamSource)source).getInputStream()) == null && (reader = ss.getReader()) != null) {
                in = new ReaderInputStream(reader);
            }
            if (in == null) {
                if (url != null) {
                    systemId = url.toString();
                    node2 = (Node)this.nodeCache.get(systemId);
                    URLConnection conn = url.openConnection();
                    Long llm = (Long)this.lastModifiedCache.get(systemId);
                    if (llm != null) {
                        lastLastModified = llm;
                        conn.setIfModifiedSince(lastLastModified);
                    }
                    conn.connect();
                    lastModified = conn.getLastModified();
                    if (node2 != null && lastModified > 0L && lastModified <= lastLastModified) {
                        return new DOMSource(node2, systemId);
                    }
                    in = conn.getInputStream();
                    this.nodeCache.put(systemId, node2);
                    this.lastModifiedCache.put(systemId, new Long(lastModified));
                } else {
                    throw new TransformerException("can't resolve URL: " + systemId);
                }
            }
            InputSource input = new InputSource(in);
            input.setSystemId(systemId);
            DocumentBuilder builder = this.getDocumentBuilder();
            node2 = builder.parse(input);
            return new DOMSource(node2, systemId);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        catch (SAXException e) {
            throw new TransformerException(e);
        }
    }

    URL resolveURL(String systemId, String base, String href) throws IOException {
        URL url = null;
        try {
            if (systemId != null) {
                try {
                    url = new URL(systemId);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (url == null) {
                if (base != null) {
                    URL baseURL = new URL(base);
                    url = new URL(baseURL, href);
                } else if (href != null) {
                    url = new URL(href);
                } else {
                    throw new MalformedURLException(systemId);
                }
            }
            return url;
        }
        catch (MalformedURLException e) {
            File file = null;
            if (href == null) {
                href = systemId;
            }
            if (base != null) {
                int lsi = base.lastIndexOf(File.separatorChar);
                if (lsi != -1 && lsi < base.length() - 1) {
                    base = base.substring(0, lsi);
                }
                File baseFile = new File(base);
                file = new File(baseFile, href);
            } else if (href != null) {
                file = new File(href);
            }
            return file == null ? null : file.toURL();
        }
    }

    DocumentBuilder getDocumentBuilder() throws TransformerException {
        try {
            if (this.builder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setExpandEntityReferences(true);
                this.builder = factory.newDocumentBuilder();
            }
            if (this.userResolver != null) {
                this.builder.setEntityResolver(new URIResolverEntityResolver(this.userResolver));
            }
            if (this.userListener != null) {
                this.builder.setErrorHandler(new ErrorListenerErrorHandler(this.userListener));
            }
            return this.builder;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    private final /* synthetic */ void this() {
        this.lastModifiedCache = new HashMap();
        this.nodeCache = new HashMap();
    }

    XSLURIResolver() {
        this.this();
    }
}

