/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.util.Iterator;
import java.util.List;
import org.javacc.jjdoc.Generator;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.parser.Action;
import org.javacc.parser.BNFProduction;
import org.javacc.parser.CharacterRange;
import org.javacc.parser.Choice;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaCodeProduction;
import org.javacc.parser.Lookahead;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.OneOrMore;
import org.javacc.parser.RCharacterList;
import org.javacc.parser.RChoice;
import org.javacc.parser.REndOfFile;
import org.javacc.parser.RJustName;
import org.javacc.parser.ROneOrMore;
import org.javacc.parser.RRepetitionRange;
import org.javacc.parser.RSequence;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RZeroOrMore;
import org.javacc.parser.RZeroOrOne;
import org.javacc.parser.RegExprSpec;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.Sequence;
import org.javacc.parser.SingleCharacter;
import org.javacc.parser.Token;
import org.javacc.parser.TokenProduction;
import org.javacc.parser.TryBlock;
import org.javacc.parser.ZeroOrMore;
import org.javacc.parser.ZeroOrOne;

public class JJDoc
extends JJDocGlobals {
    static void start() {
        generator = JJDoc.getGenerator();
        generator.documentStart();
        JJDoc.emitTokenProductions(generator, rexprlist);
        JJDoc.emitNormalProductions(generator, bnfproductions);
        generator.documentEnd();
    }

    private static Token getPrecedingSpecialToken(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        return token2 != token ? token2 : null;
    }

    private static void emitTopLevelSpecialTokens(Token token, Generator generator) {
        if (token == null) {
            return;
        }
        token = JJDoc.getPrecedingSpecialToken(token);
        String string = "";
        if (token != null) {
            cline = token.beginLine;
            ccol = token.beginColumn;
            while (token != null) {
                string = string + JJDoc.printTokenOnly(token);
                token = token.next;
            }
        }
        if (!string.equals("")) {
            generator.specialTokens(string);
        }
    }

    private static void emitTokenProductions(Generator generator, List list) {
        generator.tokensStart();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TokenProduction tokenProduction = (TokenProduction)iterator.next();
            JJDoc.emitTopLevelSpecialTokens(tokenProduction.firstToken, generator);
            String string = "";
            if (tokenProduction.isExplicit) {
                if (tokenProduction.lexStates == null) {
                    string = string + "<*> ";
                } else {
                    string = string + "<";
                    for (int i = 0; i < tokenProduction.lexStates.length; ++i) {
                        string = string + tokenProduction.lexStates[i];
                        if (i >= tokenProduction.lexStates.length - 1) continue;
                        string = string + ",";
                    }
                    string = string + "> ";
                }
                string = string + TokenProduction.kindImage[tokenProduction.kind];
                if (tokenProduction.ignoreCase) {
                    string = string + " [IGNORE_CASE]";
                }
                string = string + " : {\n";
                Iterator iterator2 = tokenProduction.respecs.iterator();
                while (iterator2.hasNext()) {
                    RegExprSpec regExprSpec = (RegExprSpec)iterator2.next();
                    string = string + JJDoc.emitRE(regExprSpec.rexp);
                    if (regExprSpec.nsTok != null) {
                        string = string + " : " + regExprSpec.nsTok.image;
                    }
                    string = string + "\n";
                    if (!iterator2.hasNext()) continue;
                    string = string + "| ";
                }
                string = string + "}\n\n";
            }
            if (string.equals("")) continue;
            generator.tokenStart(tokenProduction);
            generator.text(string);
            generator.tokenEnd(tokenProduction);
        }
        generator.tokensEnd();
    }

    private static void emitNormalProductions(Generator generator, List list) {
        generator.nonterminalsStart();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NormalProduction normalProduction = (NormalProduction)iterator.next();
            JJDoc.emitTopLevelSpecialTokens(normalProduction.getFirstToken(), generator);
            if (normalProduction instanceof BNFProduction) {
                generator.productionStart(normalProduction);
                if (normalProduction.getExpansion() instanceof Choice) {
                    boolean bl = true;
                    Choice choice = (Choice)normalProduction.getExpansion();
                    Iterator iterator2 = choice.getChoices().iterator();
                    while (iterator2.hasNext()) {
                        Expansion expansion = (Expansion)iterator2.next();
                        generator.expansionStart(expansion, bl);
                        JJDoc.emitExpansionTree(expansion, generator);
                        generator.expansionEnd(expansion, bl);
                        bl = false;
                    }
                } else {
                    generator.expansionStart(normalProduction.getExpansion(), true);
                    JJDoc.emitExpansionTree(normalProduction.getExpansion(), generator);
                    generator.expansionEnd(normalProduction.getExpansion(), true);
                }
                generator.productionEnd(normalProduction);
                continue;
            }
            if (!(normalProduction instanceof JavaCodeProduction)) continue;
            generator.javacode((JavaCodeProduction)normalProduction);
        }
        generator.nonterminalsEnd();
    }

    private static void emitExpansionTree(Expansion expansion, Generator generator) {
        if (expansion instanceof Action) {
            JJDoc.emitExpansionAction((Action)expansion, generator);
        } else if (expansion instanceof Choice) {
            JJDoc.emitExpansionChoice((Choice)expansion, generator);
        } else if (expansion instanceof Lookahead) {
            JJDoc.emitExpansionLookahead((Lookahead)expansion, generator);
        } else if (expansion instanceof NonTerminal) {
            JJDoc.emitExpansionNonTerminal((NonTerminal)expansion, generator);
        } else if (expansion instanceof OneOrMore) {
            JJDoc.emitExpansionOneOrMore((OneOrMore)expansion, generator);
        } else if (expansion instanceof RegularExpression) {
            JJDoc.emitExpansionRegularExpression((RegularExpression)expansion, generator);
        } else if (expansion instanceof Sequence) {
            JJDoc.emitExpansionSequence((Sequence)expansion, generator);
        } else if (expansion instanceof TryBlock) {
            JJDoc.emitExpansionTryBlock((TryBlock)expansion, generator);
        } else if (expansion instanceof ZeroOrMore) {
            JJDoc.emitExpansionZeroOrMore((ZeroOrMore)expansion, generator);
        } else if (expansion instanceof ZeroOrOne) {
            JJDoc.emitExpansionZeroOrOne((ZeroOrOne)expansion, generator);
        } else {
            JJDoc.error("Oops: Unknown expansion type.");
        }
    }

    private static void emitExpansionAction(Action action, Generator generator) {
    }

    private static void emitExpansionChoice(Choice choice, Generator generator) {
        Iterator iterator = choice.getChoices().iterator();
        while (iterator.hasNext()) {
            Expansion expansion = (Expansion)iterator.next();
            JJDoc.emitExpansionTree(expansion, generator);
            if (!iterator.hasNext()) continue;
            generator.text(" | ");
        }
    }

    private static void emitExpansionLookahead(Lookahead lookahead, Generator generator) {
    }

    private static void emitExpansionNonTerminal(NonTerminal nonTerminal, Generator generator) {
        generator.nonTerminalStart(nonTerminal);
        generator.text(nonTerminal.getName());
        generator.nonTerminalEnd(nonTerminal);
    }

    private static void emitExpansionOneOrMore(OneOrMore oneOrMore, Generator generator) {
        generator.text("( ");
        JJDoc.emitExpansionTree(oneOrMore.expansion, generator);
        generator.text(" )+");
    }

    private static void emitExpansionRegularExpression(RegularExpression regularExpression, Generator generator) {
        String string = JJDoc.emitRE(regularExpression);
        if (!string.equals("")) {
            generator.reStart(regularExpression);
            generator.text(string);
            generator.reEnd(regularExpression);
        }
    }

    private static void emitExpansionSequence(Sequence sequence, Generator generator) {
        boolean bl = true;
        Iterator iterator = sequence.units.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            Expansion expansion = (Expansion)iterator.next();
            if (expansion instanceof Lookahead || expansion instanceof Action) continue;
            if (!bl) {
                generator.text(" ");
            }
            boolean bl3 = bl2 = expansion instanceof Choice || expansion instanceof Sequence;
            if (bl2) {
                generator.text("( ");
            }
            JJDoc.emitExpansionTree(expansion, generator);
            if (bl2) {
                generator.text(" )");
            }
            bl = false;
        }
    }

    private static void emitExpansionTryBlock(TryBlock tryBlock, Generator generator) {
        boolean bl = tryBlock.exp instanceof Choice;
        if (bl) {
            generator.text("( ");
        }
        JJDoc.emitExpansionTree(tryBlock.exp, generator);
        if (bl) {
            generator.text(" )");
        }
    }

    private static void emitExpansionZeroOrMore(ZeroOrMore zeroOrMore, Generator generator) {
        generator.text("( ");
        JJDoc.emitExpansionTree(zeroOrMore.expansion, generator);
        generator.text(" )*");
    }

    private static void emitExpansionZeroOrOne(ZeroOrOne zeroOrOne, Generator generator) {
        generator.text("( ");
        JJDoc.emitExpansionTree(zeroOrOne.expansion, generator);
        generator.text(" )?");
    }

    private static String emitRE(RegularExpression regularExpression) {
        boolean bl;
        String string = "";
        boolean bl2 = !regularExpression.label.equals("");
        boolean bl3 = regularExpression instanceof RJustName;
        boolean bl4 = regularExpression instanceof REndOfFile;
        boolean bl5 = regularExpression instanceof RStringLiteral;
        boolean bl6 = regularExpression.tpContext != null;
        boolean bl7 = bl = bl3 || bl4 || bl2 || !bl5 && bl6;
        if (bl) {
            string = string + "<";
            if (!bl3) {
                if (regularExpression.private_rexp) {
                    string = string + "#";
                }
                if (bl2) {
                    string = string + regularExpression.label;
                    string = string + ": ";
                }
            }
        }
        if (regularExpression instanceof RCharacterList) {
            RCharacterList rCharacterList = (RCharacterList)regularExpression;
            if (rCharacterList.negated_list) {
                string = string + "~";
            }
            string = string + "[";
            Iterator iterator = rCharacterList.descriptors.iterator();
            while (iterator.hasNext()) {
                char[] cArray;
                Object e = iterator.next();
                if (e instanceof SingleCharacter) {
                    string = string + "\"";
                    cArray = new char[]{((SingleCharacter)e).ch};
                    string = string + JJDoc.add_escapes(new String(cArray));
                    string = string + "\"";
                } else if (e instanceof CharacterRange) {
                    string = string + "\"";
                    cArray = new char[]{((CharacterRange)e).getLeft()};
                    string = string + JJDoc.add_escapes(new String(cArray));
                    string = string + "\"-\"";
                    cArray[0] = ((CharacterRange)e).getRight();
                    string = string + JJDoc.add_escapes(new String(cArray));
                    string = string + "\"";
                } else {
                    JJDoc.error("Oops: unknown character list element type.");
                }
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + "]";
        } else if (regularExpression instanceof RChoice) {
            RChoice rChoice = (RChoice)regularExpression;
            Iterator iterator = rChoice.getChoices().iterator();
            while (iterator.hasNext()) {
                RegularExpression regularExpression2 = (RegularExpression)iterator.next();
                string = string + JJDoc.emitRE(regularExpression2);
                if (!iterator.hasNext()) continue;
                string = string + " | ";
            }
        } else if (regularExpression instanceof REndOfFile) {
            string = string + "EOF";
        } else if (regularExpression instanceof RJustName) {
            RJustName rJustName = (RJustName)regularExpression;
            string = string + rJustName.label;
        } else if (regularExpression instanceof ROneOrMore) {
            ROneOrMore rOneOrMore = (ROneOrMore)regularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(rOneOrMore.regexpr);
            string = string + ")+";
        } else if (regularExpression instanceof RSequence) {
            RSequence rSequence = (RSequence)regularExpression;
            Iterator iterator = rSequence.units.iterator();
            while (iterator.hasNext()) {
                RegularExpression regularExpression3 = (RegularExpression)iterator.next();
                boolean bl8 = false;
                if (regularExpression3 instanceof RChoice) {
                    bl8 = true;
                }
                if (bl8) {
                    string = string + "(";
                }
                string = string + JJDoc.emitRE(regularExpression3);
                if (bl8) {
                    string = string + ")";
                }
                if (!iterator.hasNext()) continue;
                string = string + " ";
            }
        } else if (regularExpression instanceof RStringLiteral) {
            RStringLiteral rStringLiteral = (RStringLiteral)regularExpression;
            string = string + "\"" + JavaCCParserInternals.add_escapes(rStringLiteral.image) + "\"";
        } else if (regularExpression instanceof RZeroOrMore) {
            RZeroOrMore rZeroOrMore = (RZeroOrMore)regularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(rZeroOrMore.regexpr);
            string = string + ")*";
        } else if (regularExpression instanceof RZeroOrOne) {
            RZeroOrOne rZeroOrOne = (RZeroOrOne)regularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(rZeroOrOne.regexpr);
            string = string + ")?";
        } else if (regularExpression instanceof RRepetitionRange) {
            RRepetitionRange rRepetitionRange = (RRepetitionRange)regularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(rRepetitionRange.regexpr);
            string = string + ")";
            string = string + "{";
            if (rRepetitionRange.hasMax) {
                string = string + rRepetitionRange.min;
                string = string + ",";
                string = string + rRepetitionRange.max;
            } else {
                string = string + rRepetitionRange.min;
            }
            string = string + "}";
        } else {
            JJDoc.error("Oops: Unknown regular expression type.");
        }
        if (bl) {
            string = string + ">";
        }
        return string;
    }
}

