/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ComboIcon
implements Icon {
    private final Icon icon1;
    private final Icon icon2;

    public ComboIcon(Icon icon1, Icon icon2) {
        this.icon1 = icon1;
        this.icon2 = icon2;
    }

    @Override
    public int getIconHeight() {
        int i2h;
        int i1h = this.icon1.getIconHeight();
        return i1h > (i2h = this.icon2.getIconHeight()) ? i1h : i2h;
    }

    @Override
    public int getIconWidth() {
        return this.icon1.getIconWidth() + this.icon2.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int i2h;
        int i1h = this.icon1.getIconHeight();
        int maxH = i1h > (i2h = this.icon2.getIconHeight()) ? i1h : i2h;
        this.icon1.paintIcon(c, g, x, y + (maxH - i1h) / 2);
        this.icon2.paintIcon(c, g, x + this.icon1.getIconWidth(), y + (maxH - i2h) / 2);
    }
}

