/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.samtools.SAMException;
import net.sf.samtools.util.SnappyLoader;

public class TempStreamFactory {
    private static SnappyLoader snappyLoader = null;

    private static synchronized SnappyLoader getSnappyLoader() {
        if (snappyLoader == null) {
            snappyLoader = new SnappyLoader();
        }
        return snappyLoader;
    }

    public InputStream wrapTempInputStream(InputStream inputStream, int bufferSize) {
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                return TempStreamFactory.getSnappyLoader().wrapInputStream(inputStream);
            }
            catch (Exception e) {
                throw new SAMException("Error creating SnappyInputStream", e);
            }
        }
        if (bufferSize > 0) {
            return new BufferedInputStream(inputStream, bufferSize);
        }
        return inputStream;
    }

    public OutputStream wrapTempOutputStream(OutputStream outputStream, int bufferSize) {
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                return TempStreamFactory.getSnappyLoader().wrapOutputStream(outputStream);
            }
            catch (Exception e) {
                throw new SAMException("Error creating SnappyOutputStream", e);
            }
        }
        if (bufferSize > 0) {
            return new BufferedOutputStream(outputStream, bufferSize);
        }
        return outputStream;
    }
}

