/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.EncryptionFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFPackage {
    ZipFile zip;
    Hashtable enc;
    String uniqueIdentifier;

    public OCFPackage(ZipFile zip) {
        this.zip = zip;
        this.enc = new Hashtable();
    }

    public void setEncryption(String name, EncryptionFilter encryptionFilter) {
        this.enc.put(name, encryptionFilter);
    }

    public void setUniqueIdentifier(String idval) {
        this.uniqueIdentifier = idval;
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public boolean hasEntry(String name) {
        return this.zip.getEntry(name) != null;
    }

    public boolean canDecrypt(String name) {
        EncryptionFilter filter = (EncryptionFilter)this.enc.get(name);
        if (filter == null) {
            return true;
        }
        return filter.canDecrypt();
    }

    public InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = (EncryptionFilter)this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    public HashSet getFileEntries() throws IOException {
        HashSet<String> entryNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            entryNames.add(entry.getName());
        }
        return entryNames;
    }

    public HashSet getDirectoryEntries() throws IOException {
        HashSet<String> entryNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory()) continue;
            entryNames.add(entry.getName());
        }
        return entryNames;
    }
}

