/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.component;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.wiztools.restclient.ui.component.BodyPopupMenuListener;

public class BackgroundFormatterJob {
    private final ExecutorService formatterThreadPool = Executors.newSingleThreadExecutor();
    private Future formatterFuture;

    public void run(Runnable r, final BodyPopupMenuListener listener, boolean isSeparateThread) {
        if (isSeparateThread) {
            if (this.formatterFuture != null && !this.formatterFuture.isDone()) {
                listener.onMessage("Last formatter job running!");
                return;
            }
            listener.onMessage("Starting formatter job...");
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            TimeUnit.SECONDS.sleep(30L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        if (BackgroundFormatterJob.this.formatterFuture == null || BackgroundFormatterJob.this.formatterFuture.isDone()) break;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.onMessage("Still running formatter job...");
                            }
                        });
                    }
                }
            }.start();
            this.formatterFuture = this.formatterThreadPool.submit(r);
        } else {
            r.run();
        }
    }

    public void cancelRunningJob() {
        if (this.formatterFuture != null && !this.formatterFuture.isDone()) {
            this.formatterFuture.cancel(true);
        }
    }
}

