require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_PMAP_MACHINE_)) {
    eval 'sub _PMAP_MACHINE_ () {1;}' unless defined(&_PMAP_MACHINE_);
    if(defined(&_KERNEL_OPT)) {
	require './alpha/opt_multiprocessor.ph';
    }
    require 'sys/mutex.ph';
    require 'sys/queue.ph';
    require 'machine/pte.ph';
    eval 'sub PMAP_SIZEOF {
        my($x) = @_;
	    eval q(( &ALIGN( &offsetof(\'struct pmap\',  $pm_asni[($x)]))));
    }' unless defined(&PMAP_SIZEOF);
    eval 'sub PMAP_ASN_RESERVED () {0;}' unless defined(&PMAP_ASN_RESERVED);
    eval 'sub PGA_MODIFIED () {0x1;}' unless defined(&PGA_MODIFIED);
    eval 'sub PGA_REFERENCED () {0x2;}' unless defined(&PGA_REFERENCED);
    eval 'sub PGU_NORMAL () {0;}' unless defined(&PGU_NORMAL);
    eval 'sub PGU_PVENT () {1;}' unless defined(&PGU_PVENT);
    eval 'sub PGU_L1PT () {2;}' unless defined(&PGU_L1PT);
    eval 'sub PGU_L2PT () {3;}' unless defined(&PGU_L2PT);
    eval 'sub PGU_L3PT () {4;}' unless defined(&PGU_L3PT);
    if(defined(&_KERNEL)) {
	require 'sys/atomic.ph';
	if(defined(&_KERNEL_OPT)) {
	    require './alpha/opt_dec_kn8ae.ph';
	    if(defined(&DEC_KN8AE)) {
		eval 'sub _PMAP_MAY_USE_PROM_CONSOLE () {1;}' unless defined(&_PMAP_MAY_USE_PROM_CONSOLE);
	    }
	} else {
	    eval 'sub _PMAP_MAY_USE_PROM_CONSOLE () {1;}' unless defined(&_PMAP_MAY_USE_PROM_CONSOLE);
	}
	unless(defined(&_LKM)) {
	    if(defined(&MULTIPROCESSOR)) {
		eval 'sub PMAP_TLB_SHOOTDOWN_CPUSET_DECL () {\'u_long shootset\' = 0;;}' unless defined(&PMAP_TLB_SHOOTDOWN_CPUSET_DECL);
		eval 'sub PMAP_TLB_SHOOTDOWN {
		    my($pm, $va, $pte) = @_;
    		    eval q( &pmap_tlb_shootdown(($pm), ($va), ($pte),  &shootset));
		}' unless defined(&PMAP_TLB_SHOOTDOWN);
		eval 'sub PMAP_TLB_SHOOTNOW () {
		    eval q( &pmap_tlb_shootnow( &shootset));
		}' unless defined(&PMAP_TLB_SHOOTNOW);
	    } else {
		eval 'sub PMAP_TLB_SHOOTDOWN_CPUSET_DECL () {1;}' unless defined(&PMAP_TLB_SHOOTDOWN_CPUSET_DECL);
		eval 'sub PMAP_TLB_SHOOTDOWN {
		    my($pm, $va, $pte) = @_;
    		    eval q();
		}' unless defined(&PMAP_TLB_SHOOTDOWN);
		eval 'sub PMAP_TLB_SHOOTNOW () {
		    eval q();
		}' unless defined(&PMAP_TLB_SHOOTNOW);
	    }
	}
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_copy {
	    my($dp, $sp, $da, $l, $sa) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_update {
	    my($pmap) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub PMAP_MAP_POOLPAGE {
	    my($pa) = @_;
    	    eval q( &PMAP_DIRECT_MAP($pa));
	}' unless defined(&PMAP_MAP_POOLPAGE);
	eval 'sub PMAP_UNMAP_POOLPAGE {
	    my($va) = @_;
    	    eval q( &PMAP_DIRECT_UNMAP($va));
	}' unless defined(&PMAP_UNMAP_POOLPAGE);
	eval 'sub POOL_VTOPHYS {
	    my($va) = @_;
    	    eval q( &ALPHA_K0SEG_TO_PHYS(( &vaddr_t) ($va)));
	}' unless defined(&POOL_VTOPHYS);
	eval 'sub PMAP_PAGEIDLEZERO {
	    my($pa) = @_;
    	    eval q( &pmap_pageidlezero(($pa)));
	}' unless defined(&PMAP_PAGEIDLEZERO);
	if(defined(&_PMAP_MAY_USE_PROM_CONSOLE)) {
	}
	eval 'sub pmap_pte_pa {
	    my($pte) = @_;
    	    eval q(( &PG_PFNUM(*($pte)) <<  &PGSHIFT));
	}' unless defined(&pmap_pte_pa);
	eval 'sub pmap_pte_prot {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_PROT));
	}' unless defined(&pmap_pte_prot);
	eval 'sub pmap_pte_w {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_WIRED));
	}' unless defined(&pmap_pte_w);
	eval 'sub pmap_pte_v {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_V));
	}' unless defined(&pmap_pte_v);
	eval 'sub pmap_pte_pv {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_PVLIST));
	}' unless defined(&pmap_pte_pv);
	eval 'sub pmap_pte_asm {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_ASM));
	}' unless defined(&pmap_pte_asm);
	eval 'sub pmap_pte_exec {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_EXEC));
	}' unless defined(&pmap_pte_exec);
	eval 'sub pmap_pte_set_w {
	    my($pte, $v) = @_;
    	    eval q( &do {  &if ($v) *($pte) |=  &PG_WIRED;  &else *($pte) &= ~ &PG_WIRED; }  &while (0));
	}' unless defined(&pmap_pte_set_w);
	eval 'sub pmap_pte_w_chg {
	    my($pte, $nw) = @_;
    	    eval q((($nw) ^  &pmap_pte_w($pte)));
	}' unless defined(&pmap_pte_w_chg);
	eval 'sub pmap_pte_set_prot {
	    my($pte, $np) = @_;
    	    eval q( &do { *($pte) &= ~ &PG_PROT; *($pte) |= ($np); }  &while (0));
	}' unless defined(&pmap_pte_set_prot);
	eval 'sub pmap_pte_prot_chg {
	    my($pte, $np) = @_;
    	    eval q((($np) ^  &pmap_pte_prot($pte)));
	}' unless defined(&pmap_pte_prot_chg);
	eval 'sub pmap_l1pte {
	    my($pmap, $v) = @_;
    	    eval q((($pmap)-> $pm_lev1map[ &l1pte_index(( &vaddr_t)($v))]));
	}' unless defined(&pmap_l1pte);
	eval 'sub pmap_l2pte {
	    my($pmap,$v,$l1pte) = @_;
    	    eval q({  &pt_entry_t * &lev2map;  &if ($l1pte ==  &NULL) { $l1pte =  &pmap_l1pte($pmap, $v);  &if ( &pmap_pte_v($l1pte) == 0) ( &NULL); }  &lev2map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa($l1pte)); ( $lev2map[ &l2pte_index($v)]); });
	}' unless defined(&pmap_l2pte);
	eval 'sub pmap_l3pte {
	    my($pmap,$v,$l2pte) = @_;
    	    eval q({  &pt_entry_t * &l1pte, * &lev2map, * &lev3map;  &if ($l2pte ==  &NULL) {  &l1pte =  &pmap_l1pte($pmap, $v);  &if ( &pmap_pte_v( &l1pte) == 0) ( &NULL);  &lev2map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa( &l1pte)); $l2pte =  $lev2map[ &l2pte_index($v)];  &if ( &pmap_pte_v($l2pte) == 0) ( &NULL); }  &lev3map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa($l2pte)); ( $lev3map[ &l3pte_index($v)]); });
	}' unless defined(&pmap_l3pte);
	eval 'sub PMAP_LOCK {
	    my($pmap) = @_;
    	    eval q( &mutex_enter(($pmap)-> &pm_lock));
	}' unless defined(&PMAP_LOCK);
	eval 'sub PMAP_UNLOCK {
	    my($pmap) = @_;
    	    eval q( &mutex_exit(($pmap)-> &pm_lock));
	}' unless defined(&PMAP_UNLOCK);
	eval 'sub PMAP_USERRET {
	    my($pmap) = @_;
    	    eval q( &do { \'u_long cpu_mask\' = (1 <<  &cpu_number());  &if (($pmap)-> &pm_needisync &  &cpu_mask) {  &atomic_and_ulong(($pmap)-> &pm_needisync, ~ &cpu_mask);  &alpha_pal_imb(); } }  &while (0));
	}' unless defined(&PMAP_USERRET);
	eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do { ($pg)-> ($mdpage->{pvh_list}) =  &NULL; ($pg)-> ($mdpage->{pvh_refcnt}) = 0; }  &while ( 0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
