/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ldap;

import gnu.inet.ldap.BERException;
import java.io.UnsupportedEncodingException;

public class BEREncoder {
    private byte[] buffer;
    private int offset;
    private int[] sequenceOffset;
    private int sequenceIndex;
    private boolean utf8;

    public void reset() {
        int n = 0;
        while (n < this.offset) {
            this.buffer[n] = 0;
            ++n;
        }
        this.offset = 0;
        n = 0;
        while (n < this.sequenceIndex) {
            this.sequenceOffset[n] = 0;
            ++n;
        }
        this.sequenceIndex = 0;
    }

    public int size() {
        return this.offset;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.offset];
        System.arraycopy(this.buffer, 0, byArray, 0, this.offset);
        return byArray;
    }

    public void append(boolean bl) {
        this.append(bl, 1);
    }

    public void append(boolean bl, int n) {
        this.allocate(3);
        this.buffer[this.offset++] = (byte)n;
        this.buffer[this.offset++] = 1;
        this.buffer[this.offset++] = 0 - bl;
    }

    public void append(int n) {
        this.append(n, 2);
    }

    public void append(int n, int n2) {
        int n3 = 4;
        while (((n & 0xFF800000) == 0 || (n & 0xFF800000) == -8388608) && n3 > 1) {
            --n3;
            n <<= 8;
        }
        this.allocate(n3 + 2);
        this.buffer[this.offset++] = (byte)n2;
        this.buffer[this.offset++] = (byte)n3;
        while (n3 > 0) {
            this.buffer[this.offset++] = (byte)((n & 0xFF000000) >> 24);
            --n3;
        }
    }

    public void append(byte[] byArray) throws BERException {
        this.append(byArray, 4);
    }

    public void append(byte[] byArray, int n) throws BERException {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        int n3 = n2;
        this.append(byArray, 0, n3, n);
    }

    void append(byte[] byArray, int n, int n2, int n3) throws BERException {
        this.allocate(n2 + 5);
        this.buffer[this.offset++] = (byte)n3;
        this.appendLength(n2);
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.offset, n2);
            this.offset += n2;
        }
    }

    public void append(String string) throws BERException {
        this.append(string, 12);
    }

    public void append(String string, int n) throws BERException {
        byte[] byArray = null;
        if (string == null) {
            byArray = new byte[]{};
        } else {
            String string2 = this.utf8 ? "UTF-8" : "ISO-8859-1";
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BERException("JVM does not support " + string2);
            }
        }
        int n2 = byArray.length;
        this.allocate(n2 + 5);
        this.buffer[this.offset++] = (byte)n;
        this.appendLength(n2);
        System.arraycopy(byArray, 0, this.buffer, this.offset, n2);
        this.offset += n2;
    }

    public void appendNull() {
        this.allocate(2);
        this.buffer[this.offset++] = 5;
        this.buffer[this.offset++] = 0;
    }

    private final void allocate(int n) {
        if (this.buffer.length - this.offset < n) {
            int n2 = this.buffer.length;
            while ((n2 *= 2) - this.offset < n) {
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.offset);
            this.buffer = byArray;
        }
    }

    private final void appendLength(int n) throws BERException {
        if (n < 128) {
            this.buffer[this.offset++] = (byte)n;
        } else if (n < 256) {
            this.buffer[this.offset++] = -127;
            this.buffer[this.offset++] = (byte)n;
        } else if (n < 65536) {
            this.buffer[this.offset++] = -126;
            this.buffer[this.offset++] = (byte)(n >> 8);
            this.buffer[this.offset++] = (byte)(n & 0xFF);
        } else if (n < 0x1000000) {
            this.buffer[this.offset++] = -125;
            this.buffer[this.offset++] = (byte)(n >> 16);
            this.buffer[this.offset++] = (byte)(n >> 8);
            this.buffer[this.offset++] = (byte)(n & 0xFF);
        } else {
            throw new BERException("Data too long: " + n);
        }
    }

    public void appendFilter(String string) throws BERException {
        byte[] byArray;
        if (string == null || string.length() == 0) {
            throw new BERException("Empty filter expression");
        }
        String string2 = this.utf8 ? "UTF-8" : "ISO-8859-1";
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BERException("JVM does not support " + string2);
        }
        this.appendFilter(byArray, 0);
    }

    int appendFilter(byte[] byArray, int n) throws BERException {
        int n2 = 0;
        block8: while (n < byArray.length) {
            switch (byArray[n]) {
                case 32: {
                    ++n;
                    break;
                }
                case 40: {
                    ++n2;
                    ++n;
                    break;
                }
                case 41: {
                    if (--n2 != 0) continue block8;
                    return n + 1;
                }
                case 38: {
                    n = this.appendFilterList(byArray, n + 1, 160);
                    break;
                }
                case 44: {
                    n = this.appendFilterList(byArray, n + 1, 161);
                    break;
                }
                case 33: {
                    n = this.appendFilterList(byArray, n + 1, 162);
                    break;
                }
                default: {
                    n = this.appendFilterItem(byArray, n);
                }
            }
        }
        if (n2 != 0) {
            throw new BERException("Unbalanced parentheses");
        }
        return n;
    }

    int appendFilterList(byte[] byArray, int n, int n2) throws BERException {
        BEREncoder bEREncoder = new BEREncoder(this.utf8);
        while (n < byArray.length && byArray[n] == 40) {
            n = bEREncoder.appendFilter(byArray, n);
        }
        this.append(bEREncoder.toByteArray(), n2);
        return n;
    }

    int appendFilterItem(byte[] byArray, int n) throws BERException {
        int n2;
        int n3 = BEREncoder.indexOf(byArray, (byte)61, n);
        if (n3 == -1) {
            throw new BERException("Missing '='");
        }
        int n4 = n3;
        BEREncoder bEREncoder = new BEREncoder(this.utf8);
        switch (byArray[n3 - 1]) {
            case 126: {
                n2 = 168;
                --n4;
                break;
            }
            case 62: {
                n2 = 165;
                --n4;
                break;
            }
            case 60: {
                n2 = 166;
                --n4;
                break;
            }
            case 58: {
                n2 = 169;
                break;
            }
            default: {
                int n5 = BEREncoder.indexOf(byArray, (byte)42, n3 + 1);
                if (n5 == -1) {
                    n2 = 163;
                    break;
                }
                if (n3 + 1 == byArray.length || byArray[n3 + 2] == 41) {
                    n2 = 135;
                    --n4;
                    break;
                }
                BEREncoder bEREncoder2 = new BEREncoder(this.utf8);
                bEREncoder2.append(byArray, n, n4, 4);
                n4 = BEREncoder.indexOf(byArray, (byte)41, n3 + 1);
                if (n4 == -1) {
                    throw new BERException("No terminating ')'");
                }
                BEREncoder bEREncoder3 = new BEREncoder(this.utf8);
                bEREncoder3.append(BEREncoder.unencode(byArray, n3 + 1, n4));
                bEREncoder2.append(bEREncoder3.toByteArray(), 48);
                this.append(bEREncoder2.toByteArray(), 164);
                n = n4;
                return n;
            }
        }
        bEREncoder.append(byArray, n, n4 - n, 4);
        n4 = BEREncoder.indexOf(byArray, (byte)41, n3 + 1);
        if (n4 == -1) {
            throw new BERException("No terminating ')'");
        }
        if (n2 != 135) {
            bEREncoder.append(BEREncoder.unencode(byArray, n3 + 1, n4));
        }
        this.append(bEREncoder.toByteArray(), n2);
        n = n4;
        return n;
    }

    static int indexOf(byte[] byArray, byte by, int n) {
        int n2 = n;
        while (n2 < byArray.length) {
            if (byArray[n2] == by) {
                return n2;
            }
            if (byArray[n2] == 41) {
                return -1;
            }
            ++n2;
        }
        return -1;
    }

    static byte[] unencode(byte[] byArray, int n, int n2) throws BERException {
        int n3;
        byte[] byArray2 = new byte[n2 - n];
        int n4 = 0;
        int n5 = BEREncoder.indexOf(byArray, (byte)92, n);
        while (n5 != -1) {
            if (n5 + 3 > n2) {
                throw new BERException("Illegal filter value encoding");
            }
            n3 = n5 - n;
            System.arraycopy(byArray, n, byArray2, n4, n3);
            n4 += n3;
            int n6 = Character.digit((char)byArray[n5 + 2], 16);
            byArray2[n4++] = (byte)(n6 += Character.digit((char)byArray[n5 + 1], 16) * 16);
            n5 = BEREncoder.indexOf(byArray, (byte)92, n += n3 + 3);
        }
        n3 = n2 - n;
        System.arraycopy(byArray, n, byArray2, n4, n3);
        n += n3;
        if ((n4 += n3) != byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public BEREncoder(boolean bl) {
        this(bl, 1024);
    }

    public BEREncoder(boolean bl, int n) {
        this.utf8 = bl;
        this.buffer = new byte[n];
        this.offset = 0;
        this.sequenceOffset = new int[16];
        this.sequenceIndex = 0;
    }
}

