/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class RecentFileStorage {
    public static final int MAX_ITEMS = 500;
    private static Document s_document;
    private static DocumentBuilder s_builder;
    private static File s_file;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void add(URI uRI, String string) {
        RecentFileStorage.add(uRI, string, null, false);
    }

    public static void add(URI uRI, String string, String string2, boolean bl) {
        RecentFileStorage.updateFromFile();
        NodeList nodeList = s_document.getElementsByTagName("RecentFiles");
        int n = nodeList.getLength();
        if (n == 0) {
            System.err.println("error: no tag RecentFiles");
            return;
        }
        if (n > 1) {
            System.err.println("warning: multiple tags RecentFiles");
        }
        Node node = nodeList.item(0);
        Element element = s_document.createElement("RecentItem");
        node.appendChild(element);
        Element element2 = s_document.createElement("URI");
        element2.appendChild(s_document.createTextNode(uRI.toString()));
        element.appendChild(element2);
        Element element3 = s_document.createElement("Timestamp");
        String string3 = Long.toString(System.currentTimeMillis() / 1000L);
        element3.appendChild(s_document.createTextNode(string3));
        element.appendChild(element3);
        RecentFileStorage.writeFile();
    }

    public static ArrayList getAllMimeType(String string) {
        RecentFileStorage.updateFromFile();
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = s_document.getElementsByTagName("RecentItem");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("Mime-Type");
            if (node2 == null || !(string2 = node2.getNodeValue()).equals(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static URI[] getAllGroup(String string) {
        return new URI[0];
    }

    public static boolean wasChanged() {
        if (s_document == null) {
            return true;
        }
        if (!s_file.exists()) {
            return true;
        }
        long l = System.currentTimeMillis();
        return s_file.lastModified() > l;
    }

    public static void main(String[] stringArray) {
        ArrayList arrayList = RecentFileStorage.getAllMimeType("application/x-go-sgf");
        for (int i = 0; i < arrayList.size(); ++i) {
            System.err.println(arrayList.get(i).toString());
        }
    }

    private RecentFileStorage() {
    }

    private static void updateFromFile() {
        if (!RecentFileStorage.wasChanged()) {
            return;
        }
        if (s_builder == null) {
            return;
        }
        if (!s_file.exists()) {
            RecentFileStorage.createEmptyDocument();
            return;
        }
        try {
            s_document = s_builder.parse(s_file);
            return;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        RecentFileStorage.createEmptyDocument();
    }

    private static void createEmptyDocument() {
        if (!$assertionsDisabled && s_builder == null) {
            throw new AssertionError();
        }
        s_document = s_builder.newDocument();
        Element element = s_document.createElement("RecentFiles");
        s_document.appendChild(element);
    }

    private static void writeFile() {
        try {
            s_document.normalize();
            DOMSource dOMSource = new DOMSource(s_document);
            StreamResult streamResult = new StreamResult(s_file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println(transformerConfigurationException.getMessage());
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            System.err.println(transformerException.getMessage());
            transformerException.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !RecentFileStorage.class.desiredAssertionStatus();
        s_file = new File(System.getProperties().getProperty("user.home"), ".recently-used");
        try {
            s_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException.getMessage());
            parserConfigurationException.printStackTrace();
        }
    }
}

