/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaDetailPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;

public class ConceptDetailPanel
extends FreeColPanel
implements ColopediaDetailPanel<String> {
    private static final String id = "colopediaAction." + ColopediaAction.PanelType.CONCEPTS.getKey();
    private static final String[] concepts = new String[]{"taxes", "efficiency", "education", "fortification", "independence", "ref", "interventionForce"};
    private static final Comparator<DefaultMutableTreeNode> nodeComparator = Comparator.comparing(tn -> ((ColopediaTreeItem)tn.getUserObject()).getText());
    private ColopediaPanel colopediaPanel;

    public ConceptDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient);
        this.colopediaPanel = colopediaPanel;
    }

    @Override
    public String getName() {
        return Messages.getName(id);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, this.getName(), null));
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (String concept : concepts) {
            String nodeId = "colopedia.concepts." + concept;
            String nodeName = Messages.getName(nodeId);
            nodes.add(new DefaultMutableTreeNode(new ColopediaTreeItem(this, nodeId, nodeName, null)));
        }
        Collections.sort(nodes, nodeComparator);
        for (DefaultMutableTreeNode n : nodes) {
            node.add(n);
        }
        root.add(node);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (ConceptDetailPanel.id.equals(id)) {
            return;
        }
        panel.setLayout(new MigLayout("wrap 1, center"));
        JLabel header = Utility.localizedHeaderLabel(Messages.nameKey(id), 10, FontLibrary.FontSize.SMALL);
        panel.add((Component)header, "align center, wrap 20");
        JEditorPane editorPane = new JEditorPane("text/html", Messages.getDescription(id)){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D graphics2d = (Graphics2D)g;
                graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paintComponent(graphics2d);
            }
        };
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setFont(panel.getFont());
        editorPane.setOpaque(false);
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(this.colopediaPanel);
        panel.add((Component)editorPane, "width 95%");
    }
}

