(* Lexing -- run-time library for lexers generated by mosmllex             *)
(* Closely based on the library for camllex.  Copyright 1993 INRIA, France *)

local open Obj in

type lexbuf

val createLexerString : string -> lexbuf
val createLexer       : (CharArray.array -> int -> int) -> lexbuf

val getLexeme         : lexbuf -> string
val getLexemeChar     : lexbuf -> int -> char
val getLexemeStart    : lexbuf -> int
val getLexemeEnd      : lexbuf -> int

(* For internal use in generated lexers: *)

val dummyAction       : lexbuf -> obj
val backtrack         : lexbuf -> 'a
prim_val getNextChar  : lexbuf -> char = 1 "get_next_char"

prim_val getLexBuffer     : lexbuf -> string           = 1 "field1"
prim_val getLexAbsPos     : lexbuf -> int              = 1 "field2"
prim_val getLexStartPos   : lexbuf -> int              = 1 "field3"
prim_val getLexCurrPos    : lexbuf -> int              = 1 "field4"
prim_val getLexLastPos    : lexbuf -> int              = 1 "field5"
prim_val getLexLastAction : lexbuf -> (lexbuf -> obj)  = 1 "field6"

prim_val setLexAbsPos     : lexbuf -> int -> unit             = 2 "setfield2"
prim_val setLexStartPos   : lexbuf -> int -> unit             = 2 "setfield3"
prim_val setLexCurrPos    : lexbuf -> int -> unit             = 2 "setfield4"
prim_val setLexLastPos    : lexbuf -> int -> unit             = 2 "setfield5"
prim_val setLexLastAction : lexbuf -> (lexbuf -> obj) -> unit = 2 "setfield6"
end

(* 
   These functions are for use in mosmllex-generated lexers.  For
   further information, see the Moscow ML Owner's Manual.  For
   examples, see mosml/examples/lexyacc and mosml/examples/calc.

   [lexbuf] is the type of lexer buffers.  A lexer buffer is the
   argument passed to the scanning functions defined by the
   mosmllex-generated scanners.  The lexer buffer holds the current
   state of the scanner, plus a function to refill the buffer from the
   input.

   [createLexerString s] returns a lexer buffer which reads from the
   given string s. Reading starts from the first character in the
   string.  An end-of-input condition is generated when the end of the
   string is reached.

   [createLexer f] returns a lexer buffer that will use the given
   function f for reading additional input.  When the lexer needs more
   characters, it will call the given function as (f carr n), where
   carr is a character array, and n is an integer.  The function
   should put at most characters or in carr, starting at character
   number 0, and return the number of characters actually stored.  A
   return value of 0 means end of input. 

   A lexer definition (input to mosmllex) consists of fragments of
   this form

      parse
          lhs1   { rhs1 }
        | lhs2   { rhs2 }
        | lhs3   { rhs3 }
        | ...

   where the lhs are regular expressions matching some string of
   characters, and the rhs are corresponding semantic actions, written
   in ML.  The following functions can be used in the semantic actions:

   [getLexeme lexbuf] returns the string matched by the left-hand side
   regular expression.

   [getLexemeChar lexbuf i] returns character number i in the matched
   string. 

   [getLexemeStart lexbuf] returns the start position of the matched
   string (in the input stream).  The first character in the stream
   has position 0.

   [getLexemeEnd lexbuf] returns the end position, plus one, of the
   matched string (in the input stream).  The first character in the
   stream has position 0.  
*)
