/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.PointBehaviourListener;
import uk.ac.ic.doc.scenebeans.PrimitiveBase;

public class Polygon
extends PrimitiveBase {
    private float[] _coords;

    public Polygon() {
        this._coords = new float[0];
    }

    public Polygon(float[] fArray) {
        this._coords = (float[])fArray.clone();
    }

    public Polygon(double[] dArray) {
        this._coords = new float[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this._coords[n] = (float)dArray[n];
            ++n;
        }
    }

    public Polygon(int n) {
        this._coords = new float[2 * n];
    }

    public Shape getShape(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath(1, this._coords.length / 2 + 2);
        generalPath.moveTo(this._coords[0], this._coords[1]);
        int n = 2;
        while (n < this._coords.length) {
            generalPath.lineTo(this._coords[n], this._coords[n + 1]);
            n += 2;
        }
        generalPath.closePath();
        return generalPath;
    }

    public int getPointCount() {
        return this._coords.length / 2;
    }

    public void setPointCount(int n) {
        float[] fArray = new float[n * 2];
        System.arraycopy(this._coords, 0, fArray, 0, Math.min(n * 2, this._coords.length));
        this._coords = fArray;
        this.setDirty(true);
    }

    public Point2D[] getPoints() {
        Point2D[] point2DArray = new Point2D[this._coords.length / 2];
        int n = 0;
        while (n < point2DArray.length) {
            point2DArray[n] = new Point2D.Float(this._coords[2 * n], this._coords[2 * n + 1]);
            ++n;
        }
        return point2DArray;
    }

    public Point2D getPoints(int n) {
        return new Point2D.Float(this._coords[2 * n], this._coords[2 * n + 1]);
    }

    public void setPoints(Point2D[] point2DArray) {
        this._coords = new float[point2DArray.length * 2];
        int n = 0;
        while (n < point2DArray.length) {
            this._coords[n * 2] = (float)point2DArray[n].getX();
            this._coords[n * 2 + 1] = (float)point2DArray[n].getY();
            ++n;
        }
        this.setDirty(true);
    }

    public void setPoints(int n, Point2D point2D) {
        this._coords[2 * n] = (float)point2D.getX();
        this._coords[2 * n + 1] = (float)point2D.getY();
        this.setDirty(true);
    }

    public double getXCoord(int n) {
        return this._coords[2 * n];
    }

    public void setXCoord(int n, double d) {
        this._coords[2 * n] = (float)d;
        this.setDirty(true);
    }

    public double getYCoord(int n) {
        return this._coords[2 * n + 1];
    }

    public void setYCoord(int n, double d) {
        this._coords[2 * n + 1] = (float)d;
        this.setDirty(true);
    }

    public final XCoord newXCoordAdapter(int n) {
        return new XCoord(n);
    }

    public final YCoord newYCoordAdapter(int n) {
        return new YCoord(n);
    }

    public final Points newPointsAdapter(int n) {
        return new Points(n);
    }

    public class Points
    implements PointBehaviourListener,
    Serializable {
        int _index;

        public Points(int n) {
            this._index = n;
        }

        public void behaviourUpdated(Point2D point2D) {
            Polygon.this.setPoints(this._index, point2D);
        }
    }

    public class YCoord
    implements DoubleBehaviourListener,
    Serializable {
        int _index;

        public YCoord(int n) {
            this._index = n;
        }

        public void behaviourUpdated(double d) {
            Polygon.this.setYCoord(this._index, d);
        }
    }

    public class XCoord
    implements DoubleBehaviourListener,
    Serializable {
        int _index;

        public XCoord(int n) {
            this._index = n;
        }

        public void behaviourUpdated(double d) {
            Polygon.this.setXCoord(this._index, d);
        }
    }
}

