#   Copyright (C) 1987-2007 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Sat Jan 27 16:35:09 2007
#
#

set tkg_progName TKGate 

######################################################################
#
# Set the current directory
#

set cwd [pwd]/

######################################################################
#
# Initial size of main canvas
#
set tkg_initialWidth 830
set tkg_initialHeight 590

######################################################################
#
# Executable for simulator
#
set simExec "${tkg_gateHome}/libexec/gsim"

set tkg_simCustomDelay 0
set tkg_simDefaultDelayFile "${tkg_gateHome}/gdf/default.gdf"
set tkg_simDelayFile ""

set tkg_simStepSize 1
set tkg_simClockStepSize 1
set tkg_simClockOverStep 21
set tkg_simDebugInterface 0
set tkg_contVerify 0
set tkg_simActClock ""
set tkg_simUseActClock 0
set tkg_simInitScript ""
set tkg_simSortTraces 1
set tkg_simRememberProbes 1

######################################################################
#
# Status bar and file variables
#
set tkg_currentFile	""
set tkg_displayFile	""
set tkg_modifiedFlag	0
set tkg_currentBlock	"main"
set tkg_statusMessage	""
set tkg_doBackupOnSave	1
set tkg_wantCheckpoint	0
set tkg_checkpointFreq	300
set tkg_checkpointEnabled 0

######################################################################
#
# Display modes
#
set tkg_smoothScroll 1
set tkg_regionUpdate 1
set tkg_blockMoveStyle 0
set tkg_helpBalloons 1
set tkg_noviceMode 1

######################################################################
#
# Current mode and rotation
#
set mode 1
set rot 0

######################################################################
#
# Current circuit options
#
set tkg_discardChanges 0
set tkg_useExtBars 1

######################################################################
#
# Print options
#
set tkg_printCommand "lpr"
set tkg_printPgSizeA4 4
set tkg_printPgSize 0
set tkg_printPgOrient landscape
set tkg_printDuplex 0
set tkg_printStyle fit
set tkg_printIndex 0
set tkg_printGraph 0


######################################################################
#
# Other options
#
set tkg_checkVersion	0
set tkg_defaultTech	"default"
set tkg_errorLogFile	"tkgate-error.log"
set tkg_valuePopUpDelay	333
set tkg_undoLength 50
set tkg_doSplash 1
set tkg_splashWait 1500

######################################################################
#
# Special modes
#
set tkg_enableBeakModes 0
set tkg_baderMode 0
set tkg_trekMode 0
set tkg_batMode 0
set tkg_batRate 200
set tkg_allowDebug 0

######################################################################
#
# Critical Path Options
#
set tkg_flashCPath 1
set tkg_numCPath 10
set tkg_cpathListLengths {1 5 10 25 50 100}

######################################################################
#
# Default colors
#
set tkgdef_instColor          "blue"
set tkgdef_moduleColor        "magenta4"
set tkgdef_modulePortColor    "cyan4"
set tkgdef_frameColor         "tan4"
set tkgdef_commentColor       "tan4"
set tkgdef_hyperlinkColor     "red"
set tkgdef_wireColor          "green4"
set tkgdef_busColor           "red"
set tkgdef_toolColor          "black"
set tkgdef_cpathColor         "red"
set tkgdef_gridColor          "black"
set tkgdef_oneColor           "green4"
set tkgdef_zeroColor          "magenta"
set tkgdef_floatColor         "blue"
set tkgdef_unknownColor       "red"
set tkgdef_offLedColor	      "RosyBrown1"
set tkgdef_onLedColor         "red"
set tkgdef_zLedColor          "yellow"

set tkg_instColor          $tkgdef_instColor         
set tkg_moduleColor        $tkgdef_moduleColor       
set tkg_modulePortColor    $tkgdef_modulePortColor   
set tkg_frameColor         $tkgdef_frameColor        
set tkg_commentColor       $tkgdef_commentColor      
set tkg_hyperlinkColor     $tkgdef_hyperlinkColor      
set tkg_wireColor          $tkgdef_wireColor         
set tkg_busColor           $tkgdef_busColor          
set tkg_toolColor          $tkgdef_toolColor         
set tkg_cpathColor         $tkgdef_cpathColor         
set tkg_gridColor          $tkgdef_gridColor         
set tkg_oneColor           $tkgdef_oneColor          
set tkg_zeroColor          $tkgdef_zeroColor         
set tkg_floatColor         $tkgdef_floatColor        
set tkg_unknownColor       $tkgdef_unknownColor      
set tkg_offLedColor        $tkgdef_offLedColor
set tkg_onLedColor         $tkgdef_onLedColor 
set tkg_zLedColor          $tkgdef_zLedColor  

######################################################################
#
# Fonts
#
set body_font		"-adobe-courier-medium-r-normal-*-120-*"
set smallBody_font	"-adobe-courier-medium-r-normal-*-100-*"
set boldBody_font	"-adobe-courier-bold-r-normal-*-120-*"
set boldSmallBody_font	"-adobe-courier-bold-r-normal-*-100-*"
set kanji_font          "-misc-fixed-medium-r-normal--14-130-75-75-c-140-jisx0208.1983-0"
set msg_font		"-adobe-times-medium-r-normal-*-180-*"

#
# Zoomed fonts not currently implemented.
#
set zoom1_body_font		"-adobe-courier-medium-r-normal-*-240-*"
set zoom1_smallBody_font	"-adobe-courier-medium-r-normal-*-180-*"
set zoom1_boldBody_font		"-adobe-courier-bold-r-normal-*-240-*"
set zoom1_boldSmallBody_font	"-adobe-courier-bold-r-normal-*-180-*"
set zoom1_kanji_font		"-jis-fixed-medium-r-normal--24-230-75-75-c-240-jisx0208.1983-0"

set zoom2_body_font		"-adobe-courier-medium-r-normal-*-240-*"
set zoom2_smallBody_font	"-adobe-courier-medium-r-normal-*-180-*"
set zoom2_boldBody_font		"-adobe-courier-bold-r-normal-*-240-*"
set zoom2_boldSmallBody_font	"-adobe-courier-bold-r-normal-*-180-*"
set zoom2_kanji_font		"-jis-fixed-medium-r-normal--24-230-75-75-c-240-jisx0208.1983-0"

# Dialog explaination font
font create dialogExpFont -family Helvetica -size 8

# Big dialog explaination font
font create dialogBigExpFont -family Helvetica -size 8 -weight bold

set tkg_siteName	"Earth"
catch {
    set f [open ${tkg_gateHome}/sitename.txt r]
    set tkg_siteName [gets $f]
    close $f
}

set gf_file		""
set gf_result		""
set gf_filter		".v"
set gf_filetypes {
    {{Verilog Netlist}	{.v}	}
    {{All Files}	*	}
}
set gf_vfiletypes {
    {{Verilog Netlist}	{.v}	}
    {{All Files}	*	}
}

set simScript_filter	".gss"
set simScript_filetypes {
    {{Gate Simulation Script Files}	{.gss}	}
    {{All Files}			*	}
}

set mem_filter				".mem"
set mem_filetypes {
    {{Gate Memory Image Files}		{.mem}	}
    {{All Files}			*	}
}

set gdf_filter				".gdf"
set gdf_filetypes {
    {{Gate Delay File}			{.gdf}	}
    {{All Files}			*	}
}


######################################################################
#
# Preferences options.
#

set tkg_prefFile	"~/.tkgate-preferences"

if {[file exists $tkg_prefFile]} {
  source $tkg_prefFile

  #
  # If this is an old preferences file, it could still be using the JP
  # instead of the A4 variable.
  #
  catch { set tkg_printPgSizeA4 $tkg_printPgSizeJP }
}

if {[file exists "~/.tkgaterc"]} {
  source "~/.tkgaterc"
}
