/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import java.util.stream.IntStream;
import main.Par;
import phase.CodedSteps;
import phase.EstPhase;
import phase.FixedPhaseData;
import vcf.MarkerMap;

public class PhaseData {
    private final EstPhase estPhase;
    private final float[] leaveUnphProp;
    private final long seed;
    private volatile int it;
    private volatile TrProb trProb;
    private volatile float pMismatch;

    public PhaseData(FixedPhaseData fixedPhaseData, long l) {
        this.estPhase = new EstPhase(fixedPhaseData, l);
        this.leaveUnphProp = PhaseData.leaveUnphasedProp(fixedPhaseData, this.estPhase);
        this.it = 0;
        this.seed = l;
        float f = 0.04f * fixedPhaseData.par().ne() / (float)fixedPhaseData.nHaps();
        this.trProb = new TrProb(fixedPhaseData.stage1Map(), f);
        this.pMismatch = Par.liStephensPMismatch(fixedPhaseData.nHaps());
    }

    private static float[] leaveUnphasedProp(FixedPhaseData fixedPhaseData, EstPhase estPhase) {
        int n3 = fixedPhaseData.par().iterations();
        int[] nArray = IntStream.range(0, fixedPhaseData.targGT().nSamples()).parallel().map(n -> estPhase.get(n).unphased().size()).mapToDouble(n2 -> Math.pow(n2, -1.0 / (double)n3)).mapToInt(d -> Float.floatToRawIntBits((float)d)).toArray();
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Float.intBitsToFloat(nArray[i]);
        }
        return fArray;
    }

    public float recombIntensity() {
        return this.trProb.recombIntensity;
    }

    public void updateRecombIntensity(float f) {
        if (f <= 0.0f || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        this.trProb = new TrProb(this.estPhase.fpd().stage1Map(), f);
    }

    private int ne(float f) {
        return (int)Math.floor(25.0f * f * (float)this.estPhase.fpd().nHaps());
    }

    public FloatArray pRecomb() {
        return this.trProb.pRecomb;
    }

    public float pMismatch() {
        return this.pMismatch;
    }

    public void updatePMismatch(float f) {
        if ((double)f <= 0.0 || (double)f >= 1.0 || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        this.pMismatch = f;
    }

    public void incrementIt() {
        ++this.it;
    }

    public int it() {
        return this.it;
    }

    public void advanceToFirstPhasingIt() {
        int n = this.estPhase.fpd().par().burnin();
        if (this.it < n) {
            this.it = n;
        }
    }

    public FixedPhaseData fpd() {
        return this.estPhase.fpd();
    }

    public EstPhase estPhase() {
        return this.estPhase;
    }

    public CodedSteps codedSteps() {
        return new CodedSteps(this.estPhase);
    }

    public float leaveUnphasedProp(int n) {
        return this.leaveUnphProp[n];
    }

    public long seed() {
        return this.seed + (long)this.it;
    }

    private static class TrProb {
        private final float recombIntensity;
        private final FloatArray pRecomb;

        public TrProb(MarkerMap markerMap, float f) {
            this.recombIntensity = f;
            this.pRecomb = markerMap.pRecomb(this.recombIntensity);
        }
    }
}

