/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_PLUGIN_API_H
#define _ST_PLUGIN_API_H

#include <gmodule.h>		/* plugins need G_MODULE_EXPORT */
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define ST_TYPE_PLUGIN			(st_plugin_get_type())
#define ST_PLUGIN(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_PLUGIN, STPlugin))
#define ST_PLUGIN_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_PLUGIN, STPluginClass))
#define ST_IS_PLUGIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_PLUGIN))
#define ST_IS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_PLUGIN))
#define ST_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_PLUGIN, STPluginClass))

typedef struct _STPlugin		STPlugin;
typedef struct _STPluginClass		STPluginClass;
typedef struct _STPluginPrivate		STPluginPrivate;

struct _STPlugin
{
  GObject		object;

  STPluginPrivate	*priv;

  gpointer		reserved[16];
};
  
struct _STPluginClass
{
  GObjectClass		parent_class;

  gpointer		reserved[16];
};

GType	st_plugin_get_type		(void);

void	st_plugin_set_name		(STPlugin	*plugin,
					 const char	*name);
void	st_plugin_set_label		(STPlugin	*plugin,
					 const char	*label);
void	st_plugin_set_icon_from_pixbuf	(STPlugin	*plugin,
					 GdkPixbuf	*pixbuf);

/**
 * STPluginGetInfoCallback:
 * @plugin: a plugin.
 * @err: a location to store errors.
 *
 * Specifies the type of the plugin information function.
 *
 * If a plugin contains a function named plugin_get_info(), it will be
 * called before plugin_init(). The function should set the plugin
 * information using st_plugin_set_name(), st_plugin_set_label(), etc.
 *
 * Return value: the function should return %FALSE if streamtuner must
 * not initialize the plugin. In such case it should also set @err.
 **/
typedef gboolean (*STPluginGetInfoCallback) (STPlugin *plugin, GError **err);

/**
 * STPluginInitCallback:
 * @err: a location to store errors.
 *
 * Specifies the type of the plugin initialization function.
 *
 * A plugin must contain a function named plugin_init(), which will be
 * called when the plugin is loaded.
 *
 * Return value: the function should return %FALSE if the plugin could
 * not be initialized. In such case it should also set @err.
 **/
typedef gboolean (*STPluginInitCallback) (GError **err);

G_END_DECLS

#endif /* _ST_PLUGIN_API_H */
