/*****
 NAME
 	flang.h - header file for functions for language
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 WARING
 	this file is refered by C program (not for the Objective-C).
	do not use the syntax for the Objective-C.
 */

#if !defined(FLANG_H_INCLUDED)
#define FLANG_H_INCLUDED

#include <coconut/tbasic.h>
#include <coconut/tlang.h>

void syntaxError(int lineno, const char * form, ...) ;

void setLexInputName(const utf8_char * text) ;

token_ptr doubleTextToToken(int lineno, const char * text) ;
token_ptr intTextToToken(int lineno, const char * text, int base) ;
token_ptr constStrToToken(const utf8_char * text) ;
token_ptr identStrToToken(const utf8_char * text) ;

int rwordToToken(token_ptr * ptr, const char * text) ;

void startLexString(void) ;
const utf8_char * finishLexString(void) ;
void addLexString(utf8_char c) ;

#endif /* !defined(FLANG_H_INCLUDED) */

