/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.OffscreenViewPanel;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.JLabel;
import net.claribole.zvtm.engine.Java2DPainter;
import net.claribole.zvtm.engine.Portal;
import net.claribole.zvtm.engine.RepaintListener;
import net.claribole.zvtm.engine.ViewEventHandler;
import net.claribole.zvtm.lens.Lens;

public abstract class View {
    public static final short STD_VIEW = 0;
    public static final short VOLATILE_VIEW = 1;
    public static final short OPENGL_VIEW = 2;
    Vector cameras;
    Portal[] portals = new Portal[0];
    public VCursor mouse;
    ViewPanel panel;
    boolean detectMultipleFullFills;
    JLabel statusBar;
    protected String name;
    VirtualSpaceManager parent;
    boolean notifyMouseMoved = false;
    Java2DPainter[] painters = new Java2DPainter[4];

    void initCameras(Vector c) {
        this.cameras = c;
        for (int i = 0; i < this.cameras.size(); ++i) {
            ((Camera)c.elementAt(i)).setOwningView(this);
        }
    }

    Portal addPortal(Portal p) {
        Portal[] tmpP = new Portal[this.portals.length + 1];
        System.arraycopy(this.portals, 0, tmpP, 0, this.portals.length);
        tmpP[this.portals.length] = p;
        this.portals = tmpP;
        p.setOwningView(this);
        return p;
    }

    void removePortal(Portal p) {
        for (int i = 0; i < this.portals.length; ++i) {
            if (this.portals[i] != p) continue;
            this.removePortalAtIndex(i);
            break;
        }
    }

    void removePortalAtIndex(int portalIndex) {
        Portal[] tmpP = new Portal[this.portals.length - 1];
        System.arraycopy(this.portals, 0, tmpP, 0, portalIndex);
        System.arraycopy(this.portals, portalIndex + 1, tmpP, portalIndex, this.portals.length - portalIndex - 1);
        this.portals = tmpP;
        this.panel.resetCursorInsidePortals();
    }

    public VCursor getCursor() {
        return this.mouse;
    }

    public ViewPanel getPanel() {
        return this.panel;
    }

    public abstract void destroyView();

    public abstract Container getFrame();

    public abstract void requestFocus();

    public void setCursorIcon(int cursorType) {
        this.panel.setAWTCursor(cursorType);
    }

    public void setCursorIcon(Cursor c) {
        this.panel.setAWTCursor(c);
    }

    public void setEventHandler(ViewEventHandler eh) {
        this.setEventHandler(eh, 0);
    }

    public void setEventHandler(ViewEventHandler eh, int layer) {
        this.panel.setEventHandler(eh, layer);
    }

    public void setNotifyMouseMoved(boolean b) {
        this.notifyMouseMoved = b;
    }

    public boolean getNotifyMouseMoved() {
        return this.notifyMouseMoved;
    }

    public void setStatusBarText(String s) {
        if (this.statusBar != null) {
            if (s.equals("")) {
                this.statusBar.setText(" ");
            } else {
                this.statusBar.setText(s);
            }
        }
    }

    public void setStatusBarFont(Font f) {
        if (this.statusBar != null) {
            this.statusBar.setFont(f);
        }
    }

    public void setStatusBarForeground(Color c) {
        if (this.statusBar != null) {
            this.statusBar.setForeground(c);
        }
    }

    public void setDetectMultiFills(boolean b) {
        this.detectMultipleFullFills = b;
    }

    public boolean getDetectMultiFills() {
        return this.detectMultipleFullFills;
    }

    public long[] getVisibleRegion(Camera c) {
        return this.getVisibleRegion(c, new long[4]);
    }

    public long[] getVisibleRegion(Camera c, long[] res) {
        if (this.cameras.contains(c)) {
            float uncoef = (c.focal + c.altitude) / c.focal;
            res[0] = (long)((float)c.posx - (float)(this.panel.viewW / 2L - (long)this.panel.visibilityPadding[0]) * uncoef);
            res[1] = (long)((float)c.posy + (float)(this.panel.viewH / 2L - (long)this.panel.visibilityPadding[1]) * uncoef);
            res[2] = (long)((float)c.posx + (float)(this.panel.viewW / 2L - (long)this.panel.visibilityPadding[2]) * uncoef);
            res[3] = (long)((float)c.posy - (float)(this.panel.viewH / 2L - (long)this.panel.visibilityPadding[3]) * uncoef);
            return res;
        }
        return null;
    }

    public long getVisibleRegionWidth(Camera c) {
        return (long)((float)this.panel.getSize().width * ((c.focal + c.altitude) / c.focal));
    }

    public long getVisibleRegionHeight(Camera c) {
        return (long)((float)this.panel.getSize().height * ((c.focal + c.altitude) / c.focal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        BufferedImage res = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            BufferedImage i = this.panel.getImage();
            if (i != null) {
                res = new BufferedImage(i.getWidth(), i.getHeight(), i.getType());
                Graphics2D resg2d = res.createGraphics();
                resg2d.drawImage(i, null, 0, 0);
            }
        }
        return res;
    }

    public void setActiveLayer(int i) {
        Camera c = (Camera)this.cameras.elementAt(i);
        this.mouse.unProject(c, this.panel);
        this.mouse.resetGlyphsUnderMouseList(c.parentSpace, c.getIndex());
        this.panel.activeLayer = i;
    }

    public int getActiveLayer() {
        return this.panel.activeLayer;
    }

    public int getLayerCount() {
        return this.cameras.size();
    }

    public void updateFont() {
        this.panel.updateFont = true;
    }

    public void setAntialiasing(boolean b) {
        if (b != this.panel.antialias) {
            this.panel.antialias = b;
            this.panel.updateAntialias = true;
            this.repaintNow();
        }
    }

    public boolean getAntialiasing() {
        return this.panel.antialias;
    }

    public Camera getCameraNumber(int i) {
        if (this.cameras.size() > i) {
            return (Camera)this.cameras.elementAt(i);
        }
        return null;
    }

    public Camera getActiveCamera() {
        return this.panel.cams[this.panel.activeLayer];
    }

    void destroyCamera(Camera c) {
        block0: for (int i = 0; i < this.panel.cams.length; ++i) {
            if (this.panel.cams[i] != c) continue;
            this.panel.cams[i] = null;
            if (i != this.panel.activeLayer) break;
            for (int j = 0; j < this.panel.cams.length; ++j) {
                if (this.panel.cams[j] == null) continue;
                this.panel.activeLayer = j;
                break block0;
            }
            break;
        }
        this.cameras.remove(c);
    }

    public void setBackgroundColor(Color c) {
        this.panel.backColor = c;
    }

    public Color getBackgroundColor() {
        return this.panel.backColor;
    }

    public abstract boolean isSelected();

    public abstract void setTitle(String var1);

    public abstract void setLocation(int var1, int var2);

    public abstract void setSize(int var1, int var2);

    public Dimension getPanelSize() {
        return this.panel.size;
    }

    public abstract void setResizable(boolean var1);

    public abstract void setVisible(boolean var1);

    public abstract void toFront();

    public abstract void toBack();

    public void setRefreshRate(int r) {
        this.panel.setRefreshRate(r);
    }

    public int getRefreshRate() {
        return this.panel.getRefreshRate();
    }

    public void setRepaintPolicy(boolean b) {
        this.panel.alwaysRepaintMe = b;
        if (b) {
            this.panel.active = true;
        } else if (!this.isSelected() && !this.panel.inside) {
            this.panel.active = false;
        }
    }

    public void setBlank(Color c) {
        if (c == null) {
            this.panel.blankColor = null;
            this.panel.notBlank = true;
            this.repaintNow();
        } else {
            this.panel.blankColor = c;
            this.panel.notBlank = false;
            this.repaintNow();
        }
    }

    public Color isBlank() {
        if (!this.panel.notBlank) {
            return this.panel.blankColor;
        }
        return null;
    }

    public void setComputeMouseOverListPolicy(boolean b) {
        this.panel.computeListAtEachRepaint = b;
    }

    public void activate() {
        this.parent.setActiveView(this);
        this.panel.active = true;
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewActivated(this);
        }
    }

    public void deactivate() {
        if (!this.panel.alwaysRepaintMe && !this.panel.inside) {
            this.panel.active = false;
        }
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewDeactivated(this);
        }
    }

    void iconify() {
        this.panel.active = false;
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewIconified(this);
        }
    }

    void deiconify() {
        this.panel.active = true;
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewDeiconified(this);
        }
    }

    protected void close() {
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewClosing(this);
        }
    }

    public void repaintNow() {
        this.panel.repaintNow = true;
    }

    public void repaintNow(RepaintListener rl) {
        this.panel.repaintListener = rl;
        this.panel.repaintNow = true;
    }

    public void removeRepaintListener() {
        this.panel.repaintListener = null;
    }

    public Graphics getGraphicsContext() {
        return this.panel.stableRefToBackBufferGraphics;
    }

    public Lens setLens(Lens l) {
        return this.panel.setLens(l);
    }

    public Lens getLens() {
        return this.panel.getLens();
    }

    public void rasterize(int w, int h, VirtualSpaceManager vsm, File f) {
        this.rasterize(w, h, vsm, f, null);
    }

    public void rasterize(int w, int h, VirtualSpaceManager vsm, File f, Vector layers) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        try {
            writer.setOutput(ImageIO.createImageOutputStream(f));
            BufferedImage bi = this.rasterize(w, h, vsm, layers);
            if (bi != null) {
                writer.write(bi);
                writer.dispose();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public BufferedImage rasterize(int w, int h, VirtualSpaceManager vsm) {
        return this.rasterize(w, h, vsm, (Vector)null);
    }

    public BufferedImage rasterize(int w, int h, VirtualSpaceManager vsm, Vector layers) {
        Camera nc;
        Dimension panelSize = this.panel.getSize();
        float mFactor = 1.0f / Math.min((float)w / (float)panelSize.getWidth(), (float)h / (float)panelSize.getHeight());
        Vector<Camera> clones = new Vector<Camera>();
        Vector cams = layers != null ? layers : this.cameras;
        for (int i = 0; i < cams.size(); ++i) {
            Camera c = (Camera)cams.elementAt(i);
            nc = vsm.addCamera(c.parentSpace.spaceName);
            nc.posx = c.posx;
            nc.posy = c.posy;
            nc.focal = c.focal;
            nc.altitude = (c.altitude + c.focal) * mFactor - c.focal;
            clones.add(nc);
        }
        BufferedImage img = new OffscreenViewPanel(clones).rasterize(w, h, this.panel.backColor);
        for (int i = 0; i < clones.size(); ++i) {
            nc = (Camera)clones.elementAt(i);
            vsm.getVirtualSpace(nc.parentSpace.spaceName).removeCamera(nc.index);
        }
        return img;
    }

    public void setJava2DPainter(Java2DPainter p, short g) {
        this.painters[g] = p;
        this.repaintNow();
    }

    public Java2DPainter getJava2DPainter(short g) {
        return this.painters[g];
    }

    public String getName() {
        return this.name;
    }

    public void setVisibilityPadding(int[] wnesPadding) {
        this.panel.setVisibilityPadding(wnesPadding);
    }

    public int[] getVisibilityPadding() {
        return this.panel.getVisibilityPadding();
    }

    public void setInactiveSleepTime(int t) {
        this.panel.inactiveSleepTime = t;
    }

    public void setBlankSleepTime(int t) {
        this.panel.blankSleepTime = t;
    }

    public int getInactiveSleepTime() {
        return this.panel.inactiveSleepTime;
    }

    public int getBlankSleepTime() {
        return this.panel.blankSleepTime;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

