/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.ui.util.MessageUtils;

public class InsertSizeSettingsDialog
extends JDialog {
    private boolean isCanceled = false;
    private boolean computeIsize;
    private double minPercentile;
    private double maxPercentile;
    private int minThreshold;
    private int maxThreshold;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label1;
    private JPanel panel1;
    private JCheckBox computeIsizeCB;
    private JLabel label4;
    private JLabel label5;
    private JTextField minPercentileField;
    private JTextField maxPercentileField;
    private JPanel panel2;
    private JLabel label2;
    private JLabel label3;
    private JTextField minThresholdField;
    private JTextField maxThresholdField;
    private JPanel buttonBar;
    private JButton cancelButton;
    private JButton okButton;

    public InsertSizeSettingsDialog(Frame owner, AlignmentTrack.RenderOptions options) {
        super(owner);
        this.initComponents();
        this.initValues(options);
    }

    private void initValues(AlignmentTrack.RenderOptions options) {
        this.computeIsize = options.isComputeIsizes();
        this.minPercentile = options.getMinInsertSizePercentile();
        this.maxPercentile = options.getMaxInsertSizePercentile();
        this.minThreshold = options.getMinInsertSize();
        this.maxThreshold = options.getMaxInsertSize();
        this.computeIsizeCB.setSelected(this.computeIsize);
        this.minPercentileField.setText(String.valueOf(this.minPercentile));
        this.maxPercentileField.setText(String.valueOf(this.maxPercentile));
        this.minThresholdField.setText(String.valueOf(this.minThreshold));
        this.maxThresholdField.setText(String.valueOf(this.maxThreshold));
        this.minPercentileField.setEnabled(this.computeIsize);
        this.maxPercentileField.setEnabled(this.computeIsize);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private void minThresholdFieldFocusLost(FocusEvent e) {
        this.minThresholdFieldActionPerformed(null);
    }

    private void minPercentileFieldFocusLost(FocusEvent e) {
        this.minPercentileFieldActionPerformed(null);
    }

    private void minThresholdFieldActionPerformed(ActionEvent e) {
        try {
            int tmp;
            this.minThreshold = tmp = Integer.parseInt(this.minThresholdField.getText());
        }
        catch (NumberFormatException ex) {
            MessageUtils.showMessage("Error: Default minimum threshold must be an integer.");
            this.minThresholdField.setText(String.valueOf(this.minThresholdField));
        }
    }

    private void maxThresholdFieldFocusLost(FocusEvent e) {
        this.maxThresholdFieldActionPerformed(null);
    }

    private void maxThresholdFieldActionPerformed(ActionEvent e) {
        try {
            int tmp;
            this.maxThreshold = tmp = Integer.parseInt(this.maxThresholdField.getText());
        }
        catch (NumberFormatException ex) {
            MessageUtils.showMessage("Error: Default maximum threshold must be an integer.");
            this.maxThresholdField.setText(String.valueOf(this.maxThreshold));
        }
    }

    private void maxPercentileFieldFocusLost(FocusEvent e) {
        this.maxPercentileFieldActionPerformed(null);
    }

    private void maxPercentileFieldActionPerformed(ActionEvent e) {
        try {
            double tmp = Double.parseDouble(this.maxPercentileField.getText());
            if (tmp <= 0.0 || tmp >= 100.0) {
                throw new NumberFormatException();
            }
            this.maxPercentile = tmp;
        }
        catch (NumberFormatException ex) {
            MessageUtils.showMessage("Error: Default maximum threshold must be a number between 0 and 100.");
            this.maxPercentileField.setText(String.valueOf(this.maxPercentile));
        }
    }

    private void minPercentileFieldActionPerformed(ActionEvent e) {
        try {
            double tmp = Double.parseDouble(this.minPercentileField.getText());
            if (tmp <= 0.0 || tmp >= 100.0) {
                throw new NumberFormatException();
            }
            this.minPercentile = tmp;
        }
        catch (NumberFormatException ex) {
            MessageUtils.showMessage("Error: Default minimum threshold must be a number between 0 and 100.");
            this.minPercentileField.setText(String.valueOf(this.minPercentile));
        }
    }

    private void computeIsizeCBActionPerformed(ActionEvent e) {
        this.computeIsize = this.computeIsizeCB.isSelected();
        this.minPercentileField.setEnabled(this.computeIsize);
        this.maxPercentileField.setEnabled(this.computeIsize);
    }

    private void initComponents() {
        Rectangle bounds;
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.panel1 = new JPanel();
        this.computeIsizeCB = new JCheckBox();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.minPercentileField = new JTextField();
        this.maxPercentileField = new JTextField();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.minThresholdField = new JTextField();
        this.maxThresholdField = new JTextField();
        this.buttonBar = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setBorder(null);
        this.contentPanel.setLayout(null);
        this.label1.setText("<html>These settings control color-coding of paired reads based on the inferred insert size.");
        this.contentPanel.add(this.label1);
        this.label1.setBounds(20, 15, 405, 60);
        this.panel1.setBorder(new TitledBorder("Dynamic options"));
        this.panel1.setLayout(null);
        this.computeIsizeCB.setText("Compute thresholds");
        this.computeIsizeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.computeIsizeCBActionPerformed(e);
            }
        });
        this.panel1.add(this.computeIsizeCB);
        this.computeIsizeCB.setBounds(new Rectangle(new Point(10, 25), this.computeIsizeCB.getPreferredSize()));
        this.label4.setText("Minimum percentile:");
        this.panel1.add(this.label4);
        this.label4.setBounds(10, 70, 175, this.label4.getPreferredSize().height);
        this.label5.setText("Maximum percentile:");
        this.panel1.add(this.label5);
        this.label5.setBounds(10, 100, 175, 16);
        this.minPercentileField.setEnabled(false);
        this.minPercentileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.minPercentileFieldActionPerformed(e);
            }
        });
        this.minPercentileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                InsertSizeSettingsDialog.this.minPercentileFieldFocusLost(e);
            }
        });
        this.panel1.add(this.minPercentileField);
        this.minPercentileField.setBounds(220, 64, 135, this.minPercentileField.getPreferredSize().height);
        this.maxPercentileField.setEnabled(false);
        this.maxPercentileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.maxPercentileFieldActionPerformed(e);
                InsertSizeSettingsDialog.this.maxPercentileFieldActionPerformed(e);
                InsertSizeSettingsDialog.this.maxPercentileFieldActionPerformed(e);
            }
        });
        this.maxPercentileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                InsertSizeSettingsDialog.this.maxPercentileFieldFocusLost(e);
            }
        });
        this.panel1.add(this.maxPercentileField);
        this.maxPercentileField.setBounds(220, 94, 135, 28);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.panel1.getComponentCount(); ++i) {
            bounds = this.panel1.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel1.setMinimumSize(preferredSize);
        this.panel1.setPreferredSize(preferredSize);
        this.contentPanel.add(this.panel1);
        this.panel1.setBounds(25, 210, 430, 160);
        this.panel2.setBorder(new TitledBorder("Defaults"));
        this.panel2.setLayout(null);
        this.label2.setText("Default minimum threshold: ");
        this.panel2.add(this.label2);
        this.label2.setBounds(10, 30, 205, this.label2.getPreferredSize().height);
        this.label3.setText("Default maximum threshold: ");
        this.panel2.add(this.label3);
        this.label3.setBounds(10, 60, 185, 16);
        this.minThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.minThresholdFieldActionPerformed(e);
            }
        });
        this.minThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                InsertSizeSettingsDialog.this.minThresholdFieldFocusLost(e);
            }
        });
        this.panel2.add(this.minThresholdField);
        this.minThresholdField.setBounds(215, 24, 145, this.minThresholdField.getPreferredSize().height);
        this.maxThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.maxThresholdFieldActionPerformed(e);
            }
        });
        this.maxThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                InsertSizeSettingsDialog.this.maxThresholdFieldFocusLost(e);
            }
        });
        this.panel2.add(this.maxThresholdField);
        this.maxThresholdField.setBounds(215, 54, 145, 28);
        preferredSize = new Dimension();
        for (int i = 0; i < this.panel2.getComponentCount(); ++i) {
            bounds = this.panel2.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel2.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel2.setMinimumSize(preferredSize);
        this.panel2.setPreferredSize(preferredSize);
        this.contentPanel.add(this.panel2);
        this.panel2.setBounds(25, 85, 430, 110);
        preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new FlowLayout(2));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.cancelButtonActionPerformed(e);
                InsertSizeSettingsDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add(this.cancelButton);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertSizeSettingsDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add(this.okButton);
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean isComputeIsize() {
        return this.computeIsize;
    }

    public double getMinPercentile() {
        return this.minPercentile;
    }

    public double getMaxPercentile() {
        return this.maxPercentile;
    }

    public int getMinThreshold() {
        return this.minThreshold;
    }

    public int getMaxThreshold() {
        return this.maxThreshold;
    }
}

