/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class ChunkedInputStream
extends FilterInputStream {
    byte[] one = new byte[1];
    private long chunk_len = -1L;
    private boolean eof = false;

    ChunkedInputStream(InputStream is) {
        super(is);
    }

    public synchronized int read() throws IOException {
        int b = this.read(this.one, 0, 1);
        if (b == 1) {
            return this.one[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.chunk_len == -1L) {
            try {
                this.chunk_len = Codecs.getChunkLength(this.in);
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
        }
        if (this.chunk_len > 0L) {
            int rcvd;
            if ((long)len > this.chunk_len) {
                len = (int)this.chunk_len;
            }
            if ((rcvd = this.in.read(buf, off, len)) == -1) {
                throw new EOFException("Premature EOF encountered");
            }
            this.chunk_len -= (long)rcvd;
            if (this.chunk_len == 0L) {
                this.in.read();
                this.in.read();
                this.chunk_len = -1L;
            }
            return rcvd;
        }
        Request dummy = new Request(null, null, null, null, null, null, false);
        new Response(dummy, null).readTrailers(this.in);
        this.eof = true;
        return -1;
    }

    public synchronized long skip(long num) throws IOException {
        byte[] tmp = new byte[(int)num];
        int got = this.read(tmp, 0, (int)num);
        if (got > 0) {
            return got;
        }
        return 0L;
    }

    public synchronized int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.chunk_len != -1L) {
            return (int)this.chunk_len + this.in.available();
        }
        return this.in.available();
    }
}

