/* Config.h.  Generated by configure.  */
//
// $Id: Config.h.in,v 1.28 2007/04/15 23:32:57 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(CONFIG_OL_GUARD)
#if !defined(OL_GENERATING_DOCUMENTATION)
#define CONFIG_OL_GUARD
#endif

/**
 * @defgroup Misc Types & Configuration
 *
 * Types and defined values for general use.
 */

/**
 * @file ObjectiveLib/Config.h
 *
 * Capabilities of the system that were determined or set when @b ObjectiveLib was
 * built. The values are set according to the capabilities present in the
 * system on which @b ObjectiveLib was built. Only those capabilites that are actually
 * present appear in this documentation. A complete list of definable configuration
 * settings follows so that known capabilities may be queried at compile time. All
 * of these values appear in ObjectiveLib/Config.h.
 *
 * - OL_HAVE_INTTYPES_H
 * - OL_HAVE_STDINT_H
 * - OL_HAVE_INET6_SOCKETS
 * - OL_HAVE_UNIX_SOCKETS
 * - OL_HAVE_SO_REUSEPORT
 * - OL_MAJOR_VERSION
 * - OL_MINOR_VERSION
 * - OL_PATCH_VERSION
 * - OL_NO_OPENSTEP
 * - OL_BIG_ENDIAN
 * - ICONV_CONST
 * - OL_HAVE_RANDOM
 * - OL_HAVE_LRAND48
 * - OL_HAVE_RAND_S
 * - OL_HAVE_RAND
 * - OL_WINDOWS
 *
 * @ingroup Misc
 */

/**
 * Non-zero if the file @c inttypes.h is present on the system. Indicates that the file
 * @c inttypes.h can be included.
 */
#define OL_HAVE_INTTYPES_H 1

/**
 * Non-zero if the file @c stdint.h is present on the system. Indicates that the file
 * @c stdint.h can be included.
 */
/* #undef OL_HAVE_STDINT_H */

/**
 * Non-zero if IPv6 sockets are present. If this is undefined then non of the IPv6
 * socket addressing capabilities will be present.
 */
#define OL_HAVE_INET6_SOCKETS 1

/**
 * Non-zero if Unix domain sockets are present. If this is undefined then Unix domain
 * sockets and addresses will be unavailable.
 */
#define OL_HAVE_UNIX_SOCKETS 1

/**
 * Non-zero if the socket option SO_REUSEPORT is present.
 *
 * @sa OLSocket#hasReusePortSupport, OLSocket#reusePort, OLSocket#setReusePort:
 */
#define OL_HAVE_SO_REUSEPORT 1

/**
 * The major version number of the current @b ObjectiveLib system.
 *
 * @sa OL_MINOR_VERSION, OL_PATCH_VERSION
 */
#define OL_MAJOR_VERSION 1

/**
 * The minor version number of the current @b ObjectiveLib system.
 *
 * @sa OL_MAJOR_VERSION, OL_PATCH_VERSION
 */
#define OL_MINOR_VERSION 0

/**
 * The patch version number of the current @b ObjectiveLib system.
 *
 * @sa OL_MAJOR_VERSION, OL_MINOR_VERSION
 */
#define OL_PATCH_VERSION 0

/**
 * Whether OpenStep was used to build @b ObjectiveLib.
 */
/* #undef OL_NO_OPENSTEP */

/**
 * Whether the system is big endian or little endian.
 */
#define OL_BIG_ENDIAN 1

/**
 * A qualifier for the second argument to @c iconv.
 */
#define ICONV_CONST 

/**
 * Whether the function random exists.
 */
#define OL_HAVE_RANDOM 1

/**
 * Whether the function lrand48 exists.
 */
/* #undef OL_HAVE_LRAND48 */

/**
 * Whether the function rand_s exists.
 */
/* #undef OL_HAVE_RAND_S */

/**
 * Whether the function rand exists.
 */
/* #undef OL_HAVE_RAND */

/**
 * Whether we're using the Windows platform.
 */
/* #undef OL_WINDOWS */

#endif
