/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Translation_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esearch.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esearch__OBJTOOLS_EUTILS_ESEARCH_TRANSLATION_BASE_HPP
#define esearch__OBJTOOLS_EUTILS_ESEARCH_TRANSLATION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_esearch_SCOPE
#  define BEGIN_esearch_SCOPE BEGIN_SCOPE(esearch)
#  define END_esearch_SCOPE END_SCOPE(esearch)
#endif
BEGIN_esearch_SCOPE // namespace esearch::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CTranslation_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CTranslation_Base(void);
    // destructor
    virtual ~CTranslation_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TFrom;
    typedef NCBI_NS_STD::string TTo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_From,
        e_To
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    const TFrom& GetFrom(void) const;
    void SetFrom(const TFrom& value);
    void SetFrom(TFrom&& value);
    TFrom& SetFrom(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TTo
    ///  Check whether the To data member has been assigned a value.
    bool IsSetTo(void) const;
    /// Check whether it is safe or not to call GetTo method.
    bool CanGetTo(void) const;
    void ResetTo(void);
    const TTo& GetTo(void) const;
    void SetTo(const TTo& value);
    void SetTo(TTo&& value);
    TTo& SetTo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTranslation_Base(const CTranslation_Base&);
    CTranslation_Base& operator=(const CTranslation_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_From;
    NCBI_NS_STD::string m_To;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTranslation_Base::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTranslation_Base::CanGetFrom(void) const
{
    return IsSetFrom();
}

inline
const CTranslation_Base::TFrom& CTranslation_Base::GetFrom(void) const
{
    if (!CanGetFrom()) {
        ThrowUnassigned(0);
    }
    return m_From;
}

inline
void CTranslation_Base::SetFrom(const CTranslation_Base::TFrom& value)
{
    m_From = value;
    m_set_State[0] |= 0x3;
}

inline
void CTranslation_Base::SetFrom(CTranslation_Base::TFrom&& value)
{
    m_From = std::forward<CTranslation_Base::TFrom>(value);
    m_set_State[0] |= 0x3;
}

inline
CTranslation_Base::TFrom& CTranslation_Base::SetFrom(void)
{
#ifdef _DEBUG
    if (!IsSetFrom()) {
        m_From = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_From;
}

inline
bool CTranslation_Base::IsSetTo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTranslation_Base::CanGetTo(void) const
{
    return IsSetTo();
}

inline
const CTranslation_Base::TTo& CTranslation_Base::GetTo(void) const
{
    if (!CanGetTo()) {
        ThrowUnassigned(1);
    }
    return m_To;
}

inline
void CTranslation_Base::SetTo(const CTranslation_Base::TTo& value)
{
    m_To = value;
    m_set_State[0] |= 0xc;
}

inline
void CTranslation_Base::SetTo(CTranslation_Base::TTo&& value)
{
    m_To = std::forward<CTranslation_Base::TTo>(value);
    m_set_State[0] |= 0xc;
}

inline
CTranslation_Base::TTo& CTranslation_Base::SetTo(void)
{
#ifdef _DEBUG
    if (!IsSetTo()) {
        m_To = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_To;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esearch_SCOPE // namespace esearch::


#endif // esearch__OBJTOOLS_EUTILS_ESEARCH_TRANSLATION_BASE_HPP
