/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EPostResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'epost.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef epost__OBJTOOLS_EUTILS_EPOST_EPOSTRESULT_BASE_HPP
#define epost__OBJTOOLS_EUTILS_EPOST_EPOSTRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_epost_SCOPE
#  define BEGIN_epost_SCOPE BEGIN_SCOPE(epost)
#  define END_epost_SCOPE END_SCOPE(epost)
#endif
BEGIN_epost_SCOPE // namespace epost::


// forward declarations
class CInvalidIdList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CEPostResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CEPostResult_Base(void);
    // destructor
    virtual ~CEPostResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_History : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_History(void);
        // destructor
        ~C_History(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TQueryKey;
        typedef NCBI_NS_STD::string TWebEnv;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_QueryKey,
            e_WebEnv
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// \d+ 
        /// mandatory
        /// typedef NCBI_NS_STD::string TQueryKey
        ///  Check whether the QueryKey data member has been assigned a value.
        bool IsSetQueryKey(void) const;
        /// Check whether it is safe or not to call GetQueryKey method.
        bool CanGetQueryKey(void) const;
        void ResetQueryKey(void);
        const TQueryKey& GetQueryKey(void) const;
        void SetQueryKey(const TQueryKey& value);
        void SetQueryKey(TQueryKey&& value);
        TQueryKey& SetQueryKey(void);
    
        /// \S+ 
        /// mandatory
        /// typedef NCBI_NS_STD::string TWebEnv
        ///  Check whether the WebEnv data member has been assigned a value.
        bool IsSetWebEnv(void) const;
        /// Check whether it is safe or not to call GetWebEnv method.
        bool CanGetWebEnv(void) const;
        void ResetWebEnv(void);
        const TWebEnv& GetWebEnv(void) const;
        void SetWebEnv(const TWebEnv& value);
        void SetWebEnv(TWebEnv&& value);
        TWebEnv& SetWebEnv(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_History(const C_History&);
        C_History& operator=(const C_History&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_QueryKey;
        NCBI_NS_STD::string m_WebEnv;
    };
    // types
    typedef CInvalidIdList TInvalidIdList;
    typedef C_History THistory;
    typedef NCBI_NS_STD::string TERROR;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_InvalidIdList,
        e_QW,
        e_ERROR
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CInvalidIdList TInvalidIdList
    ///  Check whether the InvalidIdList data member has been assigned a value.
    bool IsSetInvalidIdList(void) const;
    /// Check whether it is safe or not to call GetInvalidIdList method.
    bool CanGetInvalidIdList(void) const;
    void ResetInvalidIdList(void);
    const TInvalidIdList& GetInvalidIdList(void) const;
    void SetInvalidIdList(TInvalidIdList& value);
    TInvalidIdList& SetInvalidIdList(void);

    /// optional
    /// typedef C_History THistory
    ///  Check whether the History data member has been assigned a value.
    bool IsSetHistory(void) const;
    /// Check whether it is safe or not to call GetHistory method.
    bool CanGetHistory(void) const;
    void ResetHistory(void);
    const THistory& GetHistory(void) const;
    void SetHistory(THistory& value);
    THistory& SetHistory(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TERROR
    ///  Check whether the ERROR data member has been assigned a value.
    bool IsSetERROR(void) const;
    /// Check whether it is safe or not to call GetERROR method.
    bool CanGetERROR(void) const;
    void ResetERROR(void);
    const TERROR& GetERROR(void) const;
    void SetERROR(const TERROR& value);
    void SetERROR(TERROR&& value);
    TERROR& SetERROR(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEPostResult_Base(const CEPostResult_Base&);
    CEPostResult_Base& operator=(const CEPostResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TInvalidIdList > m_InvalidIdList;
    NCBI_NS_NCBI::CRef< THistory > m_History;
    NCBI_NS_STD::string m_ERROR;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEPostResult_Base::C_History::IsSetQueryKey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEPostResult_Base::C_History::CanGetQueryKey(void) const
{
    return IsSetQueryKey();
}

inline
const CEPostResult_Base::C_History::TQueryKey& CEPostResult_Base::C_History::GetQueryKey(void) const
{
    if (!CanGetQueryKey()) {
        ThrowUnassigned(0);
    }
    return m_QueryKey;
}

inline
void CEPostResult_Base::C_History::SetQueryKey(const CEPostResult_Base::C_History::TQueryKey& value)
{
    m_QueryKey = value;
    m_set_State[0] |= 0x3;
}

inline
void CEPostResult_Base::C_History::SetQueryKey(CEPostResult_Base::C_History::TQueryKey&& value)
{
    m_QueryKey = std::forward<CEPostResult_Base::C_History::TQueryKey>(value);
    m_set_State[0] |= 0x3;
}

inline
CEPostResult_Base::C_History::TQueryKey& CEPostResult_Base::C_History::SetQueryKey(void)
{
#ifdef _DEBUG
    if (!IsSetQueryKey()) {
        m_QueryKey = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_QueryKey;
}

inline
bool CEPostResult_Base::C_History::IsSetWebEnv(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEPostResult_Base::C_History::CanGetWebEnv(void) const
{
    return IsSetWebEnv();
}

inline
const CEPostResult_Base::C_History::TWebEnv& CEPostResult_Base::C_History::GetWebEnv(void) const
{
    if (!CanGetWebEnv()) {
        ThrowUnassigned(1);
    }
    return m_WebEnv;
}

inline
void CEPostResult_Base::C_History::SetWebEnv(const CEPostResult_Base::C_History::TWebEnv& value)
{
    m_WebEnv = value;
    m_set_State[0] |= 0xc;
}

inline
void CEPostResult_Base::C_History::SetWebEnv(CEPostResult_Base::C_History::TWebEnv&& value)
{
    m_WebEnv = std::forward<CEPostResult_Base::C_History::TWebEnv>(value);
    m_set_State[0] |= 0xc;
}

inline
CEPostResult_Base::C_History::TWebEnv& CEPostResult_Base::C_History::SetWebEnv(void)
{
#ifdef _DEBUG
    if (!IsSetWebEnv()) {
        m_WebEnv = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_WebEnv;
}

inline
bool CEPostResult_Base::IsSetInvalidIdList(void) const
{
    return m_InvalidIdList.NotEmpty();
}

inline
bool CEPostResult_Base::CanGetInvalidIdList(void) const
{
    return IsSetInvalidIdList();
}

inline
const CEPostResult_Base::TInvalidIdList& CEPostResult_Base::GetInvalidIdList(void) const
{
    if (!CanGetInvalidIdList()) {
        ThrowUnassigned(0);
    }
    return (*m_InvalidIdList);
}

inline
bool CEPostResult_Base::IsSetHistory(void) const
{
    return m_History.NotEmpty();
}

inline
bool CEPostResult_Base::CanGetHistory(void) const
{
    return IsSetHistory();
}

inline
const CEPostResult_Base::THistory& CEPostResult_Base::GetHistory(void) const
{
    if (!CanGetHistory()) {
        ThrowUnassigned(1);
    }
    return (*m_History);
}

inline
bool CEPostResult_Base::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEPostResult_Base::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CEPostResult_Base::TERROR& CEPostResult_Base::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(2);
    }
    return m_ERROR;
}

inline
void CEPostResult_Base::SetERROR(const CEPostResult_Base::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0x30;
}

inline
void CEPostResult_Base::SetERROR(CEPostResult_Base::TERROR&& value)
{
    m_ERROR = std::forward<CEPostResult_Base::TERROR>(value);
    m_set_State[0] |= 0x30;
}

inline
CEPostResult_Base::TERROR& CEPostResult_Base::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_ERROR;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_epost_SCOPE // namespace epost::


#endif // epost__OBJTOOLS_EUTILS_EPOST_EPOSTRESULT_BASE_HPP
