/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file IdLinkSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_IDLINKSET_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_IDLINKSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CId;
class CLinkInfo;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CIdLinkSet_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CIdLinkSet_Base(void);
    // destructor
    virtual ~CIdLinkSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CId TId;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkInfo > > TLinkInfo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Id,
        e_LinkInfo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// \d+ 
    /// mandatory
    /// typedef CId TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);
    void SetId(const NCBI_NS_STD::string& value);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkInfo > > TLinkInfo
    ///  Check whether the LinkInfo data member has been assigned a value.
    bool IsSetLinkInfo(void) const;
    /// Check whether it is safe or not to call GetLinkInfo method.
    bool CanGetLinkInfo(void) const;
    void ResetLinkInfo(void);
    const TLinkInfo& GetLinkInfo(void) const;
    TLinkInfo& SetLinkInfo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CIdLinkSet_Base(const CIdLinkSet_Base&);
    CIdLinkSet_Base& operator=(const CIdLinkSet_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TId > m_Id;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkInfo > > m_LinkInfo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CIdLinkSet_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CIdLinkSet_Base::CanGetId(void) const
{
    return true;
}

inline
const CIdLinkSet_Base::TId& CIdLinkSet_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CIdLinkSet_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CIdLinkSet_Base::TId& CIdLinkSet_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CIdLinkSet_Base::IsSetLinkInfo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CIdLinkSet_Base::CanGetLinkInfo(void) const
{
    return true;
}

inline
const CIdLinkSet_Base::TLinkInfo& CIdLinkSet_Base::GetLinkInfo(void) const
{
    return m_LinkInfo;
}

inline
CIdLinkSet_Base::TLinkInfo& CIdLinkSet_Base::SetLinkInfo(void)
{
    m_set_State[0] |= 0x4;
    return m_LinkInfo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_IDLINKSET_BASE_HPP
