/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Result_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'egquery.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef egquery__OBJTOOLS_EUTILS_EGQUERY_RESULT_BASE_HPP
#define egquery__OBJTOOLS_EUTILS_EGQUERY_RESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_egquery_SCOPE
#  define BEGIN_egquery_SCOPE BEGIN_SCOPE(egquery)
#  define END_egquery_SCOPE END_SCOPE(egquery)
#endif
BEGIN_egquery_SCOPE // namespace egquery::


// forward declarations
class CEGQueryResult;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CResult_Base(void);
    // destructor
    virtual ~CResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TTerm;
    typedef CEGQueryResult TEGQueryResult;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Term,
        e_eGQueryResult
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TTerm
    ///  Check whether the Term data member has been assigned a value.
    bool IsSetTerm(void) const;
    /// Check whether it is safe or not to call GetTerm method.
    bool CanGetTerm(void) const;
    void ResetTerm(void);
    const TTerm& GetTerm(void) const;
    void SetTerm(const TTerm& value);
    void SetTerm(TTerm&& value);
    TTerm& SetTerm(void);

    /// mandatory
    /// typedef CEGQueryResult TEGQueryResult
    ///  Check whether the EGQueryResult data member has been assigned a value.
    bool IsSetEGQueryResult(void) const;
    /// Check whether it is safe or not to call GetEGQueryResult method.
    bool CanGetEGQueryResult(void) const;
    void ResetEGQueryResult(void);
    const TEGQueryResult& GetEGQueryResult(void) const;
    void SetEGQueryResult(TEGQueryResult& value);
    TEGQueryResult& SetEGQueryResult(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CResult_Base(const CResult_Base&);
    CResult_Base& operator=(const CResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Term;
    NCBI_NS_NCBI::CRef< TEGQueryResult > m_EGQueryResult;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CResult_Base::IsSetTerm(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CResult_Base::CanGetTerm(void) const
{
    return IsSetTerm();
}

inline
const CResult_Base::TTerm& CResult_Base::GetTerm(void) const
{
    if (!CanGetTerm()) {
        ThrowUnassigned(0);
    }
    return m_Term;
}

inline
void CResult_Base::SetTerm(const CResult_Base::TTerm& value)
{
    m_Term = value;
    m_set_State[0] |= 0x3;
}

inline
void CResult_Base::SetTerm(CResult_Base::TTerm&& value)
{
    m_Term = std::forward<CResult_Base::TTerm>(value);
    m_set_State[0] |= 0x3;
}

inline
CResult_Base::TTerm& CResult_Base::SetTerm(void)
{
#ifdef _DEBUG
    if (!IsSetTerm()) {
        m_Term = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Term;
}

inline
bool CResult_Base::IsSetEGQueryResult(void) const
{
    return m_EGQueryResult.NotEmpty();
}

inline
bool CResult_Base::CanGetEGQueryResult(void) const
{
    return true;
}

inline
const CResult_Base::TEGQueryResult& CResult_Base::GetEGQueryResult(void) const
{
    if ( !m_EGQueryResult ) {
        const_cast<CResult_Base*>(this)->ResetEGQueryResult();
    }
    return (*m_EGQueryResult);
}

inline
CResult_Base::TEGQueryResult& CResult_Base::SetEGQueryResult(void)
{
    if ( !m_EGQueryResult ) {
        ResetEGQueryResult();
    }
    return (*m_EGQueryResult);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_egquery_SCOPE // namespace egquery::


#endif // egquery__OBJTOOLS_EUTILS_EGQUERY_RESULT_BASE_HPP
