/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file NameOfSubstance_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_NAMEOFSUBSTANCE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_NAMEOFSUBSTANCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CNameOfSubstance_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CNameOfSubstance_Base(void);
    // destructor
    virtual ~CNameOfSubstance_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TUI;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_UI
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TUI
        ///  Check whether the UI data member has been assigned a value.
        bool IsSetUI(void) const;
        /// Check whether it is safe or not to call GetUI method.
        bool CanGetUI(void) const;
        void ResetUI(void);
        const TUI& GetUI(void) const;
        void SetUI(const TUI& value);
        void SetUI(TUI&& value);
        TUI& SetUI(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_UI;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TNameOfSubstance;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_NameOfSubstance
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TNameOfSubstance
    ///  Check whether the NameOfSubstance data member has been assigned a value.
    bool IsSetNameOfSubstance(void) const;
    /// Check whether it is safe or not to call GetNameOfSubstance method.
    bool CanGetNameOfSubstance(void) const;
    void ResetNameOfSubstance(void);
    const TNameOfSubstance& GetNameOfSubstance(void) const;
    void SetNameOfSubstance(const TNameOfSubstance& value);
    void SetNameOfSubstance(TNameOfSubstance&& value);
    TNameOfSubstance& SetNameOfSubstance(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNameOfSubstance_Base(const CNameOfSubstance_Base&);
    CNameOfSubstance_Base& operator=(const CNameOfSubstance_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_NameOfSubstance;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNameOfSubstance_Base::C_Attlist::IsSetUI(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNameOfSubstance_Base::C_Attlist::CanGetUI(void) const
{
    return IsSetUI();
}

inline
const CNameOfSubstance_Base::C_Attlist::TUI& CNameOfSubstance_Base::C_Attlist::GetUI(void) const
{
    if (!CanGetUI()) {
        ThrowUnassigned(0);
    }
    return m_UI;
}

inline
void CNameOfSubstance_Base::C_Attlist::SetUI(const CNameOfSubstance_Base::C_Attlist::TUI& value)
{
    m_UI = value;
    m_set_State[0] |= 0x3;
}

inline
void CNameOfSubstance_Base::C_Attlist::SetUI(CNameOfSubstance_Base::C_Attlist::TUI&& value)
{
    m_UI = std::forward<CNameOfSubstance_Base::C_Attlist::TUI>(value);
    m_set_State[0] |= 0x3;
}

inline
CNameOfSubstance_Base::C_Attlist::TUI& CNameOfSubstance_Base::C_Attlist::SetUI(void)
{
#ifdef _DEBUG
    if (!IsSetUI()) {
        m_UI = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_UI;
}

inline
bool CNameOfSubstance_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CNameOfSubstance_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CNameOfSubstance_Base::TAttlist& CNameOfSubstance_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CNameOfSubstance_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CNameOfSubstance_Base::TAttlist& CNameOfSubstance_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CNameOfSubstance_Base::IsSetNameOfSubstance(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNameOfSubstance_Base::CanGetNameOfSubstance(void) const
{
    return IsSetNameOfSubstance();
}

inline
const CNameOfSubstance_Base::TNameOfSubstance& CNameOfSubstance_Base::GetNameOfSubstance(void) const
{
    if (!CanGetNameOfSubstance()) {
        ThrowUnassigned(1);
    }
    return m_NameOfSubstance;
}

inline
void CNameOfSubstance_Base::SetNameOfSubstance(const CNameOfSubstance_Base::TNameOfSubstance& value)
{
    m_NameOfSubstance = value;
    m_set_State[0] |= 0xc;
}

inline
void CNameOfSubstance_Base::SetNameOfSubstance(CNameOfSubstance_Base::TNameOfSubstance&& value)
{
    m_NameOfSubstance = std::forward<CNameOfSubstance_Base::TNameOfSubstance>(value);
    m_set_State[0] |= 0xc;
}

inline
CNameOfSubstance_Base::TNameOfSubstance& CNameOfSubstance_Base::SetNameOfSubstance(void)
{
#ifdef _DEBUG
    if (!IsSetNameOfSubstance()) {
        m_NameOfSubstance = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_NameOfSubstance;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_NAMEOFSUBSTANCE_BASE_HPP
